#ifndef _WIREFRAME_BOX_H_
#define _WIREFRAME_BOX_H_

#include "IMatrices.h"
#include "GL\glew.h"
#include <vector>

namespace Geo
{
	class WireframeBox
	{
	public:
		Geo::Data::MatSpaces mMatrices;

		GLuint mVOAID;
		std::vector<glm::vec3> mVerts;
		GLuint mVertexBuffer;
		GLuint mIndiceBuffer;
		GLuint mGreenTexture;
		GLuint mRedTexture;

		bool mHit; // If true, changes the colliders color. Helps debug

		WireframeBox();
		void Init(glm::vec3 aMin, glm::vec3 aMax);
		void Draw();
	};
}

#endif // Close _WIREFRAME_BOX_H_