#ifndef _TEXTURE_DATA_H_
#define _TEXTURE_DATA_H_

#include <string>
#include <GL\glew.h>

/*
	To add a new texture, make a new class that inherits Texture data, giving it the path to the texture. Declare a global of class at the bottom.
	In the .cpp, redeclare the global and add it in the clean up textures function
*/

namespace Textures
{
	namespace Data
	{
		class TextureData
		{
		public:
			TextureData(std::string aTexturePath); // This gets the path
			void Init(); // This loads the texture
			void CleanUp();

			GLuint mTexture;
			std::string mTexturePath;
		};

		class BrickTexture : public TextureData { public: BrickTexture()		: TextureData("media/textures/brick.tga") {} };
		class BulletTexture : public TextureData { public: BulletTexture()		: TextureData("media/textures/bullet.tga") {} };
		class DoomFontTexture : public TextureData { public: DoomFontTexture()	: TextureData("media/textures/doomFont.tga") {} };
		class FloorTexture : public TextureData { public: FloorTexture()		: TextureData("media/textures/floor.tga") {} };
		class GreenTexture : public TextureData { public: GreenTexture()		: TextureData("media/textures/green.tga") {} };
		class RedTexture : public TextureData { public: RedTexture()			: TextureData("media/textures/red.tga") {} };
		class SkyTexture : public TextureData { public: SkyTexture()			: TextureData("media/textures/sky.tga") {} };
		class WallTexture : public TextureData { public: WallTexture()			: TextureData("media/textures/wall.tga") {} };
	}

	void InitTextures();
	void CleanUpTextures();

	extern Textures::Data::BrickTexture gBrickTexture;
	extern Textures::Data::BulletTexture gBulletTexture;
	extern Textures::Data::DoomFontTexture gDoomFontTexture;
	extern Textures::Data::FloorTexture gFloorTexture;
	extern Textures::Data::GreenTexture gGreenTexture;
	extern Textures::Data::RedTexture gRedTexture;
	extern Textures::Data::SkyTexture gSkyTexture;
	extern Textures::Data::WallTexture gWallTexture;
}

#endif // Close _TEXTURE_DATA_H_