#ifndef _SOUND_MANAGER_H_
#define _SOUND_MANAGER_H_

#pragma comment(lib, "winmm.lib")
#include <Windows.h>
#include <string>
 
namespace Sounds
{
	// The sounds in the array must be in the same place as the enums' to work. It uses the enum as a index for the sound
	// UPDATE: The windows API doesn't support multiple sounds playing at once (mixing). Guess I will just have the background music
	static enum Sounds
	{
		BackgroundMusic, // Unfortunately not the whole song, though it is about 18 meg smaller (waves are big)
		BackgroundMusicBackwards,
		Pistol,
	};

	static std::string sounds[] =
	{
		"media/sounds/backgroundMusic.wav",
		"media/sounds/backgroundMusicBackwards.wav",
		"media/sounds/pistol.wav",
	};

	static void Play(Sounds aSound)
	{
		PlaySound(sounds[aSound].c_str(), NULL, SND_ASYNC);
	}

	static void PlayLooping(Sounds aSound)
	{
		PlaySound(sounds[aSound].c_str(), NULL, SND_ASYNC|SND_LOOP);
	}
}

#endif // Close _SOUND_MANAGER_H_