#ifndef _MODEL_DATA_H_
#define _MODEL_DATA_H_

#include <vector>
#include <glm\glm.hpp>

/*
	To add a model, make a new class that inherits GeoData, give it the path the the .obj, and then make a global of that class
	in the Models namespace at the bottom. In the cpp, make sure to init it in InitModels, clean it up CleanUpModels, and redeclare the global.
*/

namespace Geo
{
	namespace Data
	{
		class GeoData
		{
		public:
			GeoData(std::string aModelPath); // This sets up verts/uvs/normals/indices
			void Init(); // This makes all the buffers and such
			void CleanUp();

			std::vector<glm::vec3> mVerts;
			std::vector<glm::vec2> mUVs;
			std::vector<glm::vec3> mNormals;
			unsigned int mVertexBuffer;
			unsigned int mUVBuffer;
			unsigned int mNormalBuffer;
			unsigned int mIndiceBuffer;
			std::vector<unsigned short> mIndices;
		};

		class BrickModel : public GeoData { public: BrickModel()	: GeoData("media/models/brick.obj") {} };
		class CubeModel : public GeoData { public: CubeModel()		: GeoData("media/models/cube.obj") {} };
		class SphereModel : public GeoData { public: SphereModel()	: GeoData("media/models/sphere.obj") {} };
	}

	namespace Models
	{
		void InitModels();
		void CleanUpModels();

		extern Geo::Data::BrickModel gBrickData;
		extern Geo::Data::CubeModel gCubeData;
		extern Geo::Data::SphereModel gSphereData;
	}

}

#endif // Close _MODEL_DATA_H_