#include "Model_Data.h"
#include "Utils.h"

namespace Geo
{
	namespace Models
	{
		void InitModels()
		{
			gBrickData.Init();
			gCubeData.Init();
			gSphereData.Init();
		}

		void CleanUpModels()
		{
			gBrickData.CleanUp();
			gCubeData.CleanUp();
			gSphereData.CleanUp();
		}

		Geo::Data::BrickModel gBrickData;
		Geo::Data::CubeModel gCubeData;
		Geo::Data::SphereModel gSphereData;
	}


	namespace Data
	{
		GeoData::GeoData(std::string aModelPath)
		{
			std::vector<glm::vec3> verts;
			std::vector<glm::vec2> uvs;
			std::vector<glm::vec3> vnormals;

			bool modelLoaded = GLUtils::LoadObj(aModelPath.c_str(), verts, uvs, vnormals);
			GLUtils::IndexVBO(verts, uvs, vnormals, mIndices, mVerts, mUVs, mNormals);
		}

		void GeoData::Init()
		{
			glGenBuffers(1, &mVertexBuffer);
			glBindBuffer(GL_ARRAY_BUFFER, mVertexBuffer);
			glBufferData(GL_ARRAY_BUFFER, mVerts.size() * sizeof(glm::vec3), &mVerts[0], GL_STATIC_DRAW);

			glGenBuffers(1, &mUVBuffer);
			glBindBuffer(GL_ARRAY_BUFFER, mUVBuffer);
			glBufferData(GL_ARRAY_BUFFER, mUVs.size() * sizeof(glm::vec2), &mUVs[0], GL_STATIC_DRAW);

			glGenBuffers(1, &mNormalBuffer);
			glBindBuffer(GL_ARRAY_BUFFER, mNormalBuffer);
			glBufferData(GL_ARRAY_BUFFER, mNormals.size() * sizeof(glm::vec3), &mNormals[0], GL_STATIC_DRAW);

			glGenBuffers(1, &mIndiceBuffer);
			glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, mIndiceBuffer);
			glBufferData(GL_ELEMENT_ARRAY_BUFFER, mIndices.size() * sizeof(unsigned short), &mIndices[0], GL_STATIC_DRAW);
		}

		void GeoData::CleanUp()
		{
			glDeleteBuffers(1, &mVertexBuffer);
			glDeleteBuffers(1, &mUVBuffer);
			glDeleteBuffers(1, &mNormalBuffer);
			glDeleteBuffers(1, &mIndiceBuffer);
		}
	}
}