#ifndef _I_MATRICES_H_
#define _I_MATRICES_H_

#include <glm\glm.hpp>
#include <glm\ext.hpp>

namespace Geo
{
	namespace Data
	{
		class MatSpaces
		{
		public:
			glm::mat4 mModel;	// Model to world
			glm::mat4 mMV;		// Model and View
			glm::mat4 mMVP;		// Model View Projection

			MatSpaces() : mModel(1.0f), mMV(1.0f), mMVP(1.0f) {}

			glm::vec3 GetLocation() { return glm::vec3(mModel[3][0], mModel[3][1], mModel[3][2]); }
			glm::vec3 GetScale()	{ return glm::vec3(mModel[0][0], mModel[1][1], mModel[2][2]); }
			void SetPosition(glm::vec3 aLoc)
			{
				mModel[3][0] = aLoc.x;
				mModel[3][1] = aLoc.y;
				mModel[3][2] = aLoc.z;
			}
			void AppendLocation(glm::vec3 aLoc) { mModel = glm::translate(mModel, aLoc); }

			void SetScale(glm::vec3 aScale)
			{
				mModel[0][0] = aScale.x;
				mModel[1][1] = aScale.y;
				mModel[2][2] = aScale.x;
			}
			void AppendScale(glm::vec3 aScale)	{ mModel = glm::scale(mModel, aScale); }
		};

		class IMatrices
		{
		protected:
			MatSpaces mMatrices;
		public:
			MatSpaces& GetMatrices() { return mMatrices; }
			void SetMatrices(MatSpaces aMat) { mMatrices = aMat; }
		};
	}
}
/*			void SetLocation(glm::vec3 aLoc)
			{
				mModel[3][0] = aLoc.x;
				mModel[3][1] = aLoc.y;
				mModel[3][2] = aLoc.z;
			}
			void AppendLocation(glm::vec3 aLoc)
			{
				mModel[3][0] += aLoc.x;
				mModel[3][1] += aLoc.y;
				mModel[3][2] += aLoc.z;
			}
			void SetScale(glm::vec3 aScale)
			{
				mModel[0][0] = aScale.x;
				mModel[1][1] = aScale.y;
				mModel[2][2] = aScale.x;
			}
			void AppendScale(glm::vec3 aScale)
			{
				mModel[0][0] += aScale.x;
				mModel[1][1] += aScale.y;
				mModel[2][2] += aScale.x;
			}*/
#endif // Close _I_MATRICES_H_