#ifndef _GLOBAL_PROPERTIES_H_
#define _GLOBAL_PROPERTIES_H_

namespace GlobalProperties
{
	/*
		To allow easy modifications without diving into the code!

		Takes a bit of time to re-complie though... Should make this an external file so I can just read it in
	*/

	// Screen
	const unsigned short SCREEN_WIDTH = 1024;
	const unsigned short SCREEN_HEIGHT = 768;
	const unsigned short SCREEN_WIDTH_HALF = SCREEN_WIDTH / 2;
	const unsigned short SCREEN_HEIGHT_HALF = SCREEN_HEIGHT / 2;
	const bool BACKFACE_CULLING = true;
	const float LINE_DRAW_THICKNESS = 2.0f; // For wireframe boxes

	// Input
	const bool ALLOW_KEYBOARD_INPUT = true;
	const bool ALLOW_MOUSE_INPUT = true;
	const bool SHOW_MOUSE_CURSOR = false;
	const float MOUSE_H_SPEED = 0.04f;
	const float MOUSE_V_SPEED = 0.04f;

	// Camera Default Settings
	const float CAMERA_FOV = 60.0f;
	const float CAMERA_ASPECT_RATIO = 4.0f/3.0f;
	const float CAMERA_NEAR_PLANE = 0.1f;
	const float CAMERA_FAR_PLANE = 100.0f;
	const float CAMERA_START_POS[] = { 0.0f, 0.0f, -5.0f };
	const float CAMERA_MOVE_SPEED = 5.0f;
	const float CAMERA_MOVE_SPEED_MULTIPLIER = 2.0f;
	const float CAMERA_IN_ROOM_TOLERANCE = 0.5f;
	const float CAMERA_STAY_IN_ROOM = true;

	// Lights
	const bool ENABLE_AMBIENT = true;
	const bool ENABLE_DIFFUSE = true;
	const bool ENABLE_SPECULAR = true;
	const float LIGHT_COLOR[] = { 1.0f, 1.0f, 1.0f };
	const float AMBIENT_INTENSITY = 0.5f;
	const float DIFFUSE_DIR[] = { 0.0f, 1.0f, 0.0f };
	const float DIFFUSE_INTENSITY = 0.75f;
	const float SPEC_INTENSITY = 0.35f;
	const float SPEC_POWER = 0.25f;

	// Physics
	//#define USE_OCTREE
	const bool DRAW_OCTREE = true;
	const bool DRAW_COLLIDERS = false;
	const float FRICTION = 0.05f;					// Is applied when objects collide
	const float DRAG = 0.015f;						// Is applied every frame
	const float GRAVITY[] = { 0.0f, -9.8f, 0.0f };	// Could have some fun if I don't make it const...
	const float TERMINAL_VELOCITY = 500.0f;			// If xyz can not be greater than this
	const float VELOCITY_MIN = 0.005f;				// Will set xyz to 0 if lower than this
	const float SLEEP_EPSILON = 0.09f;				// If an objects RWA is lower than this for SLEEP_FRAMES time, it will sleep
	const unsigned short SLEEP_FRAMES = 4;
	const unsigned short NUM_OF_COLLISION_CHECKS = 1;// Having more collisions smooths out the stacking, but slows the program

	// Rewind
	const int EVERY_SAVE_FRAME = 6;						// Saves every n amount of frames (I have it at 6 frames, so about 10 times a second)
	const int MAX_SAVE_FRAMES = 1200;					// How many frames it can rewind. (1200 is about a 2 min rewind if it runs at 60fps)
	const unsigned short SAVE_FLOAT_PRECISION = 1000;	// Precision of saved float. 100 goes from about -300 - 300, 1000 to about -30 - 30

	// Game
	const float ROOM_SIZE = 10.0f;	// How big the room is. Example 10.0f means the rooms goes from -10 to 10 is all dimensions
	const float BULLET_SPEED = 400.0f;
	const unsigned short BRICK_COUNT = 77;
	const char CONTROLS_TEXT[] = "CONTROLS: \nMovement-WASD + Mouse \nShoot-Left Click \nRun-Shift \nRewind-Spacebar \nQuit-Escape";
	const bool LOG_FPS = false;		// Shows the FPS every frame
}

#endif // Close _GLOBAL_PROPERTIES_H_