#ifndef _GEO_OBJ_GROUP_H_
#define _GEO_OBJ_GROUP_H_

#include "Geo_Obj_Textured.h"
#include <list>

namespace Geo
{
	class GeoObjGroup
	{
		std::list<GeoObjTextured*> mObjects;

	public:
		void InsertObject(GeoObjTextured* aObj);
		void RemoveObject(GeoObjTextured* aObj);
		void DrawGroup();
		void CleanUp();

		void SetPosition(glm::vec3 aPos);
		void Translate(glm::vec3 aVec);
		void SetScale(glm::vec3 aScale);
		void Scale(glm::vec3 aScale);
	};
}

#endif // Close _GEO_OBJ_GROUP_H_