#include "Geo_Obj_Group.h"

namespace Geo
{
	void GeoObjGroup::InsertObject(GeoObjTextured* aObj)
	{
		if (aObj)
			mObjects.push_back(aObj);
	}

	void GeoObjGroup::RemoveObject(GeoObjTextured* aObj)
	{
		if (aObj)
			mObjects.remove(aObj);
	}

	void GeoObjGroup::DrawGroup()
	{
		for (std::list<GeoObjTextured*>::iterator i = mObjects.begin(); i != mObjects.end(); ++i)
			(*i)->UpdateBindRender();
	}

	void GeoObjGroup::CleanUp()
	{
		for (std::list<GeoObjTextured*>::iterator i = mObjects.begin(); i != mObjects.end(); ++i)
			(*i)->CleanUp();
	}

	void GeoObjGroup::SetPosition(glm::vec3 aPos)
	{
		for (std::list<GeoObjTextured*>::iterator i = mObjects.begin(); i != mObjects.end(); ++i)
			(*i)->SetPosition(aPos);
	}

	void GeoObjGroup::Translate(glm::vec3 aVec)
	{
		for (std::list<GeoObjTextured*>::iterator i = mObjects.begin(); i != mObjects.end(); ++i)
			(*i)->Translate(aVec);
	}

	void GeoObjGroup::SetScale(glm::vec3 aScale)
	{
		for (std::list<GeoObjTextured*>::iterator i = mObjects.begin(); i != mObjects.end(); ++i)
			(*i)->SetScale(aScale);
	}

	void GeoObjGroup::Scale(glm::vec3 aScale)
	{
		for (std::list<GeoObjTextured*>::iterator i = mObjects.begin(); i != mObjects.end(); ++i)
			(*i)->Scale(aScale);
	}
}