#ifndef _GL_HELPER_UTILS_H_
#define _GL_HELPER_UTILS_H_

#include <GL\glew.h>
#include <glm\glm.hpp>
#include <vector>

namespace GLUtils
{
	// This must be called in an update function to work!
	void CalculateFrameRate();
	glm::vec3 Lerp(glm::vec3 aFromPos, glm::vec3 aToPos, float aTime);

	GLuint LoadShaders(const char* aVertFilePath, const char* aFragFilePath);

	bool LoadObj(const char* aFilePath,
				std::vector<glm::vec3>& aOutVerts,
				std::vector<glm::vec2>& aOutUVs,
				std::vector<glm::vec3>& aOutNorms);
	GLuint LoadTGA(const char* aFilePath);

	void IndexVBO(
				std::vector<glm::vec3>& aInVerts,
				std::vector<glm::vec2>& aInUVs,
				std::vector<glm::vec3>& aInNorms,

				std::vector<unsigned short>& aOutIndices,
				std::vector<glm::vec3>& aOutVerts,
				std::vector<glm::vec2>& aOutUVs,
				std::vector<glm::vec3>& aOutNorms
				);
	void IndexVBO(
				std::vector<glm::vec3>& aInVerts,
				std::vector<unsigned short>& aOutIndices,
				std::vector<glm::vec3>& aOutVerts
				);
}

#endif // Close _GL_HELPER_UTILS_H_