#include "Texture_Data.h"
#include "Utils.h"

namespace Textures
{
	void InitTextures()
	{
		gBrickTexture.Init();
		gBulletTexture.Init();
		gDoomFontTexture.Init();
		gFloorTexture.Init();
		gGreenTexture.Init();
		gRedTexture.Init();
		gSkyTexture.Init();
		gWallTexture.Init();
	}

	void CleanUpTextures()
	{
		gBrickTexture.CleanUp();
		gBulletTexture.CleanUp();
		gDoomFontTexture.CleanUp();
		gFloorTexture.CleanUp();
		gGreenTexture.CleanUp();
		gRedTexture.CleanUp();
		gSkyTexture.CleanUp();
		gWallTexture.CleanUp();
	}

	Data::BrickTexture gBrickTexture;
	Data::BulletTexture gBulletTexture;
	Data::DoomFontTexture gDoomFontTexture;
	Data::FloorTexture gFloorTexture;
	Data::GreenTexture gGreenTexture;
	Data::RedTexture gRedTexture;
	Data::SkyTexture gSkyTexture;
	Data::WallTexture gWallTexture;

	namespace Data
	{
		TextureData::TextureData(std::string aTexturePath) : mTexture(0)
		{
			mTexturePath = aTexturePath;
		}

		void TextureData::Init()
		{
			mTexture = GLUtils::LoadTGA(mTexturePath.c_str());
		}

		void TextureData::CleanUp()
		{
			glDeleteTextures(1, &mTexture);
		}
	}
}