#ifndef __SHADER_H__
#define __SHADER_H__

#include <GL\glew.h>
#include "IMatrices.h"

namespace Shaders
{
	class Shader
	{
	protected:
		GLuint mProgId;
		GLuint mvpId;
		GLuint mId;
		GLuint mvId;

		GLuint mCameraPosId;

	public:
		virtual void Init() = 0;
		void Activate();
		void UpdateCamData();
		void UpdateMatrices(Geo::Data::MatSpaces& aMat);
		void CleanUp();
	};

	class AmbDifSpecShader : public Shader
	{
		GLuint mTextureId;

		// Used in lighting
		GLuint mLightColorId;
		GLuint mAmbientIntensityId;
		GLuint mDiffuseDirId;
		GLuint mDiffuseIntensityId;
		GLuint mSpecMatIntId;
		GLuint mSpecMatPowerId;

		// Used to turn lights on or off
		bool mEnableAmbient;
		bool mEnableDiffuse;
		bool mEnableSpecular;

		// Variables used in the shader
		glm::vec3 mLightColor; // ambient/diffuse/spec all use this same light color

		float mAmbientIntensity;
		glm::vec3 mDiffuseDir;
		float mDiffuseIntensity;
		float mSpecMatInt;
		float mSpecMatPower;

	public:
		void Init();
		void UpdateLights();

		GLuint GetTextureId() const { return mTextureId; }
	};


	class ColorShader : public Shader
	{
	public:
		void Init();
	};
}

#endif // Close __SHADER_H__