#ifndef _REWINDABLE_H_
#define _REWINDABLE_H_

#include <glm\glm.hpp>
#include "Geo_Obj_Textured.h"
#include <list>

namespace Rewind
{
	// Rewindable will have a list of these to know where to rewind to when rewinding
	struct LastPos
	{
	private:
		short mX;
		short mY;
		short mZ;

		short FloatToShort(float aFloat); // These are for packing/unpacking the floats into shorts. Takes half the memory when saving!
		float ShortToFloat(short aShort);

	public:
		void SetPosition(glm::vec3 aPosition);
		glm::vec3 GetPosition();
	};

	// This class is really just a data container; the Rewind_Manager does all the work
	class Rewindable
	{
		std::list<LastPos> mLastPositions;
		Geo::GeoObjTextured* mGeoObj; // I feel like I can change this to something more generic to have it rewind more things...

		glm::vec3 mStartPos;	//When rewinding, where you are lerping from	
		glm::vec3 mToPos;		//When rewinding, where you are lerping to

	public:
		Rewindable();
		void InitRewindable(Geo::GeoObjTextured& aGeoObj);

		void RewindMove(float aT); // Simply lerps to from mStartPos to mEndPos
		void AddPosition(bool aRemoveFront);// Adds your current position to the mLastPositions list.
		void GoToNextPosition(bool aRemoveOldPosition); // When you are rewinding, rewindManager calls this to tell you to go to your next position
	};
}
#endif // Close _REWINDABLE_H_