#ifndef _REWIND_MANAGER_H_
#define _REWIND_MANAGER_H_

#include "Rewindable.h"
#include <list>

namespace Rewind
{
	class RewindManager
	{
		// Singleton
		static RewindManager* sInstance;
		RewindManager();
		RewindManager(const RewindManager& rw) {}

		std::list<Rewindable*> mRewindables;
		std::list<unsigned int> mSavedTimeStamps; // Keeps a list of all the times things were saved

		bool mIsRewinding;
		unsigned int mTimeStamp; //The all mighty time stamp. Lets things know when to do stuff
		unsigned short mFrameCounter; // Counts up to mEverySaveFrame, saves rewindables' positions, goes back to 0. Helps lerp when rewinding also

		void SavePositions(); // Goes through rewindables and saves their current positions
		void SetFirstRewindPoint(); // Right when you start rewinding, sets all rewindables first points to go to
		void SetNextRewindPoint(); // When you hit the next mTimestampsSaved when rewinding, goes through all rewindables and sets their next lerp
		void CheckInput();
		void RewindStart();
		void EndRewind();

	public:
		static RewindManager& I();
		void Update();
		void Init();

		void AddRewinable(Rewindable& aRewindable) { mRewindables.push_back(&aRewindable); }
		bool IsRewinding() const { return mIsRewinding; }
	};
}

#endif // Close _REWIND_MANAGER_H_