#ifndef _OCTREE_H_
#define _OCTREE_H_

#include "Collider.h"
#include "Wireframe_Box.h"
#include <glm\glm.hpp>
#include <set>
#include <vector>

struct CollliderPair
{
	Collider* a;
	Collider* b;
};

const int MAX_OCTREE_DEPTH = 3;
const int MIN_COLLIDERS_PER_OCTREE = 3;
const int MAX_COLLIDERS_PER_OCTREE = 6;

class Octree
{
	glm::vec3 mMin;
	glm::vec3 mMax;
	glm::vec3 mCenter;

	// [0] is mins (left 4 for x, bottom 4 for y, back 4 for z) [1] is for maxes.
	Octree* mChildren[2][2][2];
	std::set<Collider*> mColliders;
	bool mHasChildren;
	int mDepth;
	int mColliderCount;
	Geo::WireframeBox mWireframeBox;

	void File(Collider* aCol, glm::vec3 aPos, bool aAdd); // Adds (or removes) a collider from this trees children
	void CreateChildren();
	void Collect(std::set<Collider*>& aSet); // Gets all colliders from this tree and all children trees, and puts them into aSet
	void DestroyChildren(); // Calls collect, putting them all into mColliders, while deleting all the children
	void Remove(Collider* aCol, glm::vec3 aPos);

public:
	Octree(glm::vec3 aMin, glm::vec3 aMax, int aDepth);
	~Octree();

	void Add(Collider* aCol);
	void Remove(Collider* aCol); // Don't quite understand this one. Probably going to delete it TODO
	void MoveCollider(Collider* aCol, glm::vec3 aOldPos);
	void PotentialCollisions(std::vector<CollliderPair>& aVec); // Finds all potential collisions and puts them into aVec
	void Draw(); // For debugging
};

#endif // Close _OCTREE_H_