#ifndef _INPUT_MACROS_H_
#define _INPUT_MACROS_H_

/*
	This code is used to make the addition of new input logic easier and less error prone
	We used this in our OpenGL projects at school while learning about macros
*/

//This is the body of the class
#define ADD_INPUT_KEY(Name) \
	private: \
	int m##Name##KeyCode; \
	bool m##Name##KeyState; \
	bool m##Name##PreviousKeyState; \
	public: \
	void Set##Name##KeyCode(int aCode) { m##Name##KeyCode = aCode; } \
	int Get##Name##KeyCode() const { return m##Name##KeyCode; } \
	bool Get##Name##KeyState() const { return m##Name##KeyState; } \
	bool Get##Name##KeyStateDown() const { return !m##Name##PreviousKeyState && m##Name##KeyState; } \
	bool Get##Name##KeyStateUp() const { return m##Name##PreviousKeyState && !m##Name##KeyState; } \

// This is like the constructor for each input key
#define INIT_INPUT_KEY(Name, Code) \
	m##Name##KeyCode = Code; \
	m##Name##KeyState = false; \

// This update is used for keyboard input
#define UPDATE_KEYBOARD_BUTTON(Name) \
	m##Name##PreviousKeyState = m##Name##KeyState; \
	m##Name##KeyState = glfwGetKey(m##Name##KeyCode) == GLFW_PRESS; \

// This update is used for mouse button input
#define UPDATE_MOUSE_BUTTON(Name) \
	m##Name##PreviousKeyState = m##Name##KeyState; \
	m##Name##KeyState = glfwGetMouseButton(m##Name##KeyCode) == GLFW_PRESS; \

#endif // Close _INPUT_MACROS_H_