#ifndef _HUB_H_
#define _HUB_H_

#include "Camera.h"
#include "IMatrices.h"
#include "Shader.h"

/*
	This class connects things that I don't want talking to (or knowing about) each other
*/

class Hub
{
	// Singleton
	static Hub* sInstance;
	Hub() {}
	Hub(const Hub& hub) {}

	PerspectiveCamera* mCamera;
	Shaders::AmbDifSpecShader* mShader;

public:
	static Hub& I();

	// Camera
	void UpdateCamMatrices(Geo::Data::MatSpaces& aSpaces);
	void SetCamera(PerspectiveCamera* aCam) { mCamera = aCam; }
	PerspectiveCamera& GetCamera() { return *mCamera; }

	// Shader
	void UpdateCamData(Geo::Data::MatSpaces& aMat);
	void SetShader(Shaders::AmbDifSpecShader* aShader) { mShader = aShader; }
	Shaders::AmbDifSpecShader& GetShader() { return *mShader; }
};

#endif // Close _HUB_H_