#ifndef _GEO_OBJECTS_H_
#define _GEO_OBJECTS_H_
#include "Geo_Obj_Physics.h"
#include "Geo_Obj_Group.h"
#include "Bullet.h"
#include "Rewindable.h"
#include "Texture_Data.h"

using namespace Textures::Data;

namespace Geo
{
	class PlasmaBullet : public Bullet
	{
	public:
		PlasmaBullet();
		PlasmaBullet(TextureData& aTextureData);
	};

	class Brick : public GeoObjPhysics, public Rewind::Rewindable
	{
		void Init();
	public:
		Brick();
		Brick(TextureData& aTextureData);
	};

	class Wall : public GeoObjPhysics
	{
		void Init();
	public:
		Wall();
		Wall(TextureData& aTextureData);
	};

	class Room : public GeoObjGroup
	{
		Wall w1, w2, w3, w4, w5, w6;
	public:
		Room(float aRoomSize);
	};

	class Cube : public GeoObjTextured
	{
	public:
		Cube();
		Cube(TextureData& aTextureData);
	};

}

#endif // Close _GEO_OBJECTS_H_