#include "Geo_Objects.h"
#include "Model_Data.h"

namespace Geo
{
	PlasmaBullet::PlasmaBullet() : Bullet(Models::gSphereData, Textures::gBulletTexture) {}
	PlasmaBullet::PlasmaBullet(TextureData& aTextureData) : Bullet(Models::gSphereData, aTextureData) {}

	Brick::Brick() : GeoObjPhysics(Models::gBrickData, Textures::gBrickTexture)					{ Init(); }
	Brick::Brick(TextureData& aTextureData) : GeoObjPhysics(Models::gBrickData, aTextureData)	{ Init(); }
	void Brick::Init()
	{
		InitRewindable(*this);
	}

	Wall::Wall() : GeoObjPhysics(Models::gCubeData, Textures::gWallTexture)					{ Init(); }
	Wall::Wall(TextureData& aTextureData) : GeoObjPhysics(Models::gCubeData, aTextureData)	{ Init(); }
	void Wall::Init()
	{
		SetUseGravity(false);	// They aren't going to fall from gravity
		SetIsKinematic(true);	// They won't move from hitting other objects
		SetMass(0.0f);			// 0 is infinite
	}

	Room::Room(float aRoomSize) : w5(Textures::gSkyTexture), w6(Textures::gFloorTexture)
	{
		// Scale them up
		w1.SetScale(glm::vec3(aRoomSize, aRoomSize, aRoomSize));
		w2.SetScale(glm::vec3(aRoomSize, aRoomSize, aRoomSize));
		w3.SetScale(glm::vec3(aRoomSize, aRoomSize, aRoomSize));
		w4.SetScale(glm::vec3(aRoomSize, aRoomSize, aRoomSize));
		w5.SetScale(glm::vec3(aRoomSize, aRoomSize, aRoomSize));
		w6.SetScale(glm::vec3(aRoomSize, aRoomSize, aRoomSize));

		// Move them out
		w1.SetPosition(glm::vec3(aRoomSize*2, 0.0f, 0.0f));
		w2.SetPosition(glm::vec3(-aRoomSize*2, 0.0f, 0.0f));
		w3.SetPosition(glm::vec3(0.0f, 0.0f, aRoomSize*2));
		w4.SetPosition(glm::vec3(0.0f, 0.0f, -aRoomSize*2));
		w5.SetPosition(glm::vec3(0.0f, aRoomSize*2, 0.0f));
		w6.SetPosition(glm::vec3(0.0f, -aRoomSize*2, 0.0f));

		// Put them in the group
		InsertObject(&w1);
		InsertObject(&w2);
		InsertObject(&w3);
		InsertObject(&w4);
		InsertObject(&w5);
		InsertObject(&w6);
	}

	Cube::Cube() : GeoObjTextured(Models::gCubeData, Textures::gGreenTexture) {}
	Cube::Cube(TextureData& aTextureData) : GeoObjTextured(Models::gCubeData, aTextureData) {}


}