#ifndef _GEO_OBJ_TEXTURED_H_
#define _GEO_OBJ_TEXTURED_H_

#include <GL\glew.h>
#include "IMatrices.h"
#include "Model_Data.h"
#include "Texture_Data.h"

namespace Geo
{
	class GeoObjTextured : public Data::IMatrices
	{
	protected:
		GLuint mVOAID;
		Data::GeoData& mModelData;
		Textures::Data::TextureData& mTextureData;
		bool mRendererEnabled; // If false, will not render

	public:
		GeoObjTextured(Data::GeoData& aModelData, Textures::Data::TextureData& aTextureData);
		void Bind();
		void Render();
		void SetTextureData(GLuint aTextureSlot, GLuint aUniformTextureId);
		void CleanUp();

		glm::vec3 GetPosition() { return GetMatrices().GetLocation(); }
		glm::vec3 GetScale() { return GetMatrices().GetScale(); }

		virtual void UpdateBindRender();
		virtual void UpdateCamData();
		virtual void SetPosition(glm::vec3 aPos){ GetMatrices().SetPosition(aPos); }
		virtual void Translate(glm::vec3 aVec)	{ GetMatrices().AppendLocation(aVec); }
		virtual void SetScale(glm::vec3 aScale) { GetMatrices().SetScale(aScale); }
		virtual void Scale(glm::vec3 aScale)	{ GetMatrices().AppendScale(aScale); }
	};
}

#endif // Close _GEO_OBJ_TEXTURED_H_