#ifndef _COLLIDER_H_
#define _COLLIDER_H_

#include <gl\glew.h>
#include <glm\glm.hpp>
#include "IMatrices.h"
#include "Wireframe_Box.h"
#include "Model_Data.h"

// Forward declaration
namespace Geo 
{
	class GeoObjPhysics;
}

class Collider
{
	glm::vec3 mBoundsMin;
	glm::vec3 mBoundsMax;

	bool mEnabled; // If false, won't be checked for collisions

	Geo::WireframeBox mWireframeBox;

public:
	Collider();
	void CreateBoundingBox(Geo::Data::GeoData& aModelData);
	void Draw();
	void SetScale(glm::vec3 aScale);
	void Scale(glm::vec3 aScale);

	void SetHit(bool aState) { mWireframeBox.mHit = aState; }
	void SetEnabled(bool aState) { mEnabled = aState; }
	bool IsEnabled() const { return mEnabled; }
	glm::vec3 GetBoundsMin() const { return mBoundsMin; }
	glm::vec3 GetBoundsMax() const { return mBoundsMax; }
	glm::vec3 GetBoundsMinFromCenter() { return mBoundsMin + GetCenter(); }
	glm::vec3 GetBoundsMaxFromCenter() { return mBoundsMax + GetCenter(); }
	glm::vec3 GetCenter() { return GetMatrices().GetLocation(); }
	Geo::Data::MatSpaces& GetMatrices() { return mWireframeBox.mMatrices; }


	#ifdef USE_OCTREE
private:
	Geo::GeoObjPhysics* mPhysicsObject;
public:
	void SetPhysicsObject(Geo::GeoObjPhysics* aObj) { mPhysicsObject = aObj; }
	Geo::GeoObjPhysics* GetPhysicsObject() { return mPhysicsObject; }
	#endif
};

#endif // Close _COLLIDER_H_