#include "Collider.h"
#include "Utils.h"
#include "Hub.h"
#include "Global_Properties.h"
#include <vector>

Collider::Collider() : mEnabled(true), mBoundsMax(0), mBoundsMin(0)
{}

void Collider::CreateBoundingBox(Geo::Data::GeoData& aModelData)
{
	float minX, maxX, minY, maxY, minZ, maxZ;

	minX = maxX = aModelData.mVerts[0].x;
	minY = maxY = aModelData.mVerts[0].y;
	minZ = maxZ = aModelData.mVerts[0].z;

	// Find mins/maxes
	for (std::vector<glm::vec3>::iterator i = aModelData.mVerts.begin()+1; i != aModelData.mVerts.end(); ++i)
	{
		if ((*i).x < minX) minX = (*i).x;
		if ((*i).x > maxX) maxX = (*i).x;
		if ((*i).y < minY) minY = (*i).y;
		if ((*i).y > maxY) maxY = (*i).y;
		if ((*i).z < minZ) minZ = (*i).z;
		if ((*i).z > maxZ) maxZ = (*i).z;
	}

	mBoundsMin = glm::vec3(minX, minY, minZ);
	mBoundsMax = glm::vec3(maxX, maxY, maxZ);
	GetMatrices().SetPosition(glm::vec3((minX-maxX)/2, (minY-maxY)/2, (minZ-maxZ)/2));

	if (GlobalProperties::DRAW_COLLIDERS)
		mWireframeBox.Init(mBoundsMin, mBoundsMax);
}

void Collider::Draw()
{
	mWireframeBox.Draw();
}

void Collider::SetScale(glm::vec3 aScale)
{
	glm::vec3 oldScale = GetMatrices().GetScale();
	GetMatrices().SetScale(aScale);

	glm::vec3 newScale = GetMatrices().GetScale() / oldScale;

	mBoundsMax *= newScale;
	mBoundsMin *= newScale;
}

void Collider::Scale(glm::vec3 aScale)
{
	GetMatrices().AppendScale(aScale);
	mBoundsMax *= aScale;
	mBoundsMin *= aScale;
}