#include "Bullet.h"
#include "Global_Properties.h"
#include "Hub.h"

Bullet::Bullet(Geo::Data::GeoData& aModelData, Textures::Data::TextureData& aTextureData) : GeoObjPhysics(aModelData, aTextureData)
{
	Disable();
	mMass = 0.025f;
	SetScale(glm::vec3(0.15f));
	//mIsKinematic = true;
	//mUseGravity = false;
}

void Bullet::Shoot()
{
	PerspectiveCamera& aCam = Hub::I().GetCamera();

	SetPosition(aCam.GetPosition());
	mVelocity = -aCam.GetViewForward() * GlobalProperties::BULLET_SPEED;

	mRendererEnabled = true;
	mCollider.SetEnabled(true);
	mIsSleeping = false;
}

void Bullet::Disable()
{
	SetPosition(glm::vec3(0));
	mRendererEnabled = false;
	mCollider.SetEnabled(false);
	mIsSleeping = true;
}