//TODO
//Check costs of fully upgaded weapons to make sure the costs go up right
#pragma region Declarations
#include <string>
#include <iostream>
#include <conio.h>
#include <iomanip>
#include <windows.h>

using namespace std;

const int weaponStatLength = 6;
const int weaponCostLength = 5;
const float SELLMULTIPLIER = 0.5f;

const int SELECTEDCOLOR = 143;
const int UNSELECTEDCOLOR = 7;
const int GREYCOLOR = 8;
const int WHITECOLOR = 15;
const int GOLDCOLOR = 6;
const int TEALCOLOR = 3;
const int BLUECOLOR = 9;
const int REDCOLOR = 4;
const int YELLOWCOLOR = 14;
const char BOX = (char)254;

const string FPDESCRIPTION = " Firepower \nIncreases the firepower. \n(The firepower of the standard handgun is \nequivalent to 1.0)";
const string FSDESCRIPTION = " Firing Speed \nIncreases the speed at which the weapon fires. \n(Numerical values are in seconds)";
const string RSDESCRIPTION = " Reload Speed \nIncreases the reloading speed. \n(Numerical values are in seconds)";
const string CDESCRIPTION = " Capacity \nIncreases the round capacity of the firearm. \n(Numerical values are the number of rounds)";

const string BUYMINETHROWER = "Not only will you need cash, but you'll \nneed guts to buy that weapon.";
const string buyBB = "I see you have an eye for things.\nGun's not just about shootin'. It's about \nreloadin'. You'll know what I'm talkin' about.";

//Structs
struct item
{
	string name;
	string description;
	bool sellOnly;
	bool isWeapon;
	int cost;
	int quantity;
	int sellQuantity;
};

struct weapon : item
{
	bool upgradable;

	int baseCost;
	string descriptionBase;
	string descriptionExclusive;
	string exclusiveDescription;
	float exclusiveStat;
	int exclusiveCost;
	bool hasExclusive;

	float firePower;
	float statFirePower[weaponStatLength];
	int firePowerCosts[weaponCostLength];
	int firePowerLevel;
	int firePowerMaxLevel;

	float firingSpeed;
	float statFiringSpeed[weaponStatLength];
	int firingSpeedCosts[weaponCostLength];
	int	firingSpeedLevel;
	int firingSpeedMaxLevel;

	float reloadSpeed;
	float statReloadSpeed[weaponStatLength];
	int reloadSpeedCosts[weaponCostLength];
	int reloadSpeedLevel;
	int reloadSpeedMaxLevel;

	float capacity;
	float statCapacity[weaponStatLength];
	int capacityCosts[weaponCostLength];
	int capacityLevel;
	int capacityMaxLevel;
};

//Variables
int input;
int selection = 1;
int level;
int cash;
int sellAmount;

int selectionLevel = 0;
int ps[3];
item items[10];
item itemArray[3];
weapon weaponArray[7];
int inventory[10];
int merchantSelling[10];

int itemsLength(sizeof(items) / sizeof(items[0]));
int itemArrayLength(sizeof(itemArray) / sizeof(itemArray[0]));
int weaponArrayLength(sizeof(weaponArray) / sizeof(weaponArray[0]));
int inventoryLength(sizeof(inventory) / sizeof(inventory[0]));
int merchantSellingLength(sizeof(merchantSelling) / sizeof(merchantSelling[0]));

//Fuctions
void Initialize();
void ShowBuyItems(int _cash);
void ShowSellItems(int _cash);
void ShowUpgradeItems(int _cash);
void ShowUpgrades(int _cash, int _select, int _max);
void GetInput(int _maxSelections);
void ShowYesNo();
void SelectingUpgrades(weapon& _w, item& _i, string _stat, int &_cash);
void ShowWeaponStats(weapon& _w, item& _i, int _n, bool _highlight);
bool BuySellMessage();
int RoundUp(int numberToRound);
void SortInventory(bool _upgradables);
int GetItemCost(item _item);
BOOL SetSelectedColor();
BOOL SetUnselectedColor();
BOOL SetGreyedColor();
void ClearScreen();
void ResetSelection(bool _in);
void DisableCursor();
#pragma endregion

int main()
{
	#pragma region Initialize
	Initialize();

	//Starting inventory
	int cash = 1000000;

	items[8].quantity = 15;
	items[9].quantity = 1;
	items[0].quantity = 1;
	items[0].sellQuantity = 0;
		items[1].quantity = 1;
	items[1].sellQuantity = 0;
		items[2].quantity = 1;
	items[2].sellQuantity = 0;
		items[3].quantity = 1;
	items[3].sellQuantity = 0;
		items[4].quantity = 1;
	items[4].sellQuantity = 0;
		items[5].quantity = 1;
	items[5].sellQuantity = 0;
		items[6].quantity = 1;
	items[6].sellQuantity = 0;
		items[7].quantity = 1;
	items[7].sellQuantity = 0;

	#pragma endregion

	while (true)
	{
		#pragma region StartScreen
		level = 0;
		system("cls");

		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), GOLDCOLOR);
		cout << "\"Welcome!\"" << endl
			 << endl;

		cout << ((selection == 1) ? SetSelectedColor() : SetUnselectedColor()) << "\b" << "1. Sell" << endl;
		cout << ((selection == 2) ? SetSelectedColor() : SetUnselectedColor()) << "\b" << "2. Buy" << endl;
		cout << ((selection == 3) ? SetSelectedColor() : SetUnselectedColor()) << "\b" << "3. Tune up" << endl;
		cout << ((selection == 4) ? SetSelectedColor() : SetUnselectedColor()) << "\b" << "4. Cancel" << endl;
		cout << endl;
		SetUnselectedColor();

		GetInput(5);

		//Last minute switch of Buy and Sell
		if (input == 1)
			input = 2;
		else if (input == 2)
			input = 1;

		//Make it so you can't sell if you have nothing
		if (input == 2)
		{
			SortInventory(false);
			if (inventory[0] == -1)
				input = 0;
		}

		if (input == 1 || input == 2 || input == 3)
		{
			level = input;
			ResetSelection(true);
		}
		#pragma endregion

		#pragma region Buying
		while (level == 1)
		{
			ShowBuyItems(cash);

			int maxNumber = 1;
			for (int i = 0; i < itemsLength; i++)
			{
				if (items[i].sellOnly == false)
					maxNumber++;
			}
			GetInput(maxNumber);

			//b goes back
			if (input == -1)
			{
				ResetSelection(false);
				break;
			}

			//Select an item
			if (input > 0 && input - 1 < maxNumber && items[merchantSelling[input - 1]].sellQuantity > 0)
			{
				ps[selectionLevel] = selection;
				selectionLevel += 1;
				while (true)
				{
					//Dont have enough cash
					if (cash < items[merchantSelling[input - 1]].cost)
					{
						SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), GOLDCOLOR);
						cout << endl << "\"Not enough cash, stranger!\"";
						_getch();
						system("cls");
						input = 0;
						break;
					}

					int select = input - 1;
					ShowYesNo();

					if (input == 1)
					{
						items[merchantSelling[select]].quantity += 1;
						items[merchantSelling[select]].sellQuantity -= 1;
						cash -= items[merchantSelling[select]].cost;

						SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), GOLDCOLOR);
						cout << endl << endl << "\"Ehehe.....thank you!\"";
						_getch();
						ResetSelection(false);
						break;
					}
					else if (input == -1)
					{
						ResetSelection(false);
						break;
					}
				}
			}
		}
		#pragma endregion

		#pragma region Selling
		while (level == 2)
		{
			sellAmount = 1; //Need to reset this, or it messes up cost display
			ShowSellItems(cash);

			//Go back if you run out of things to sell
			if (inventory[0] == -1)
			{
				ResetSelection(false);
				break;
			}

			int maxNumber = 1;
			for (int i = 0; i < inventoryLength && inventory[i] != -1; i++)
				maxNumber++;

			GetInput(maxNumber);

			//b goes back
			if (input == -1)
			{
				ResetSelection(false);
				break;
			}

			//Select an item
			if (input > 0 && items[inventory[input - 1]].quantity > 0)
			{
				ps[selectionLevel] = selection;
				selectionLevel += 1;

				while (true)
				{
					int select = input - 1;
					ShowYesNo();

					if (input == 1)
					{
						//Reset weapons to default
						if (items[inventory[select]].isWeapon)
						{
							items[inventory[select]].cost = weaponArray[inventory[select]].baseCost;
							items[inventory[select]].description = weaponArray[inventory[select]].descriptionBase;
							weaponArray[inventory[select]].hasExclusive = false;
							weaponArray[inventory[select]].firePower = weaponArray[inventory[select]].statFirePower[0];
							weaponArray[inventory[select]].firePowerLevel = 1;
							weaponArray[inventory[select]].firingSpeed = weaponArray[inventory[select]].statFiringSpeed[0];
							weaponArray[inventory[select]].firingSpeedLevel = 1;
							weaponArray[inventory[select]].reloadSpeed = weaponArray[inventory[select]].statReloadSpeed[0];
							weaponArray[inventory[select]].reloadSpeedLevel = 1;
							weaponArray[inventory[select]].capacity = weaponArray[inventory[select]].statCapacity[0];
							weaponArray[inventory[select]].capacityLevel = 1;
						}

						cash += GetItemCost(items[inventory[select]]);
						items[inventory[select]].quantity -= sellAmount;
						items[inventory[select]].sellQuantity += sellAmount;

						SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), GOLDCOLOR);
						cout << endl << endl << "\"Ehehe.....thank you!\"";
						_getch();
						ResetSelection(false);
						break;
					}
					else if (input == -1)
					{
						ResetSelection(false);
						break;
					}
				}
			}
		}
		#pragma endregion

		#pragma region Upgrading
		while (level == 3)
		{
			ShowUpgradeItems(cash);

			int maxNumber = 1; //+1 for back button
			for (int i = 0; i < weaponArrayLength; i++)
			{
				if (items[i].isWeapon && weaponArray[i].upgradable)
					maxNumber++;
			}

			GetInput(maxNumber);

			//b goes back
			if (input == -1)
			{
				ResetSelection(false);
				break;
			}

			//Select an item
			if (input > 0 && input - 1 < maxNumber && !weaponArray[inventory[input - 1]].hasExclusive && items[inventory[input - 1]].quantity > 0)
			{
				system("cls");
				int select = input - 1;
				ResetSelection(true);

				while (true)
				{
					int max = 0;
					weapon& w = weaponArray[inventory[select]];
					if (w.firePowerLevel == w.firePowerMaxLevel && w.firingSpeedLevel == w.firingSpeedMaxLevel &&
						w.reloadSpeedLevel == w.reloadSpeedMaxLevel && w.capacityLevel == w.capacityMaxLevel)
						max = 6;
					else
						max = 5;

					ShowUpgrades(cash, select, max);
					GetInput(max);

					//Select firepower
					if (input == 1 && w.firePowerLevel != w.firePowerMaxLevel)
						SelectingUpgrades(w, items[inventory[select]], "firePower", cash);

					//Select firing speed
					if (input == 2 && w.firingSpeedLevel != w.firingSpeedMaxLevel)
						SelectingUpgrades(w, items[inventory[select]], "firingSpeed", cash);

					//Select reload speed
					if (input == 3 && w.reloadSpeedLevel != w.reloadSpeedMaxLevel)
						SelectingUpgrades(w, items[inventory[select]], "reloadSpeed", cash);

					//Select capacity
					if (input == 4 && w.capacityLevel != w.capacityMaxLevel)
						SelectingUpgrades(w, items[inventory[select]], "capacity", cash);

					//Select exclusive
					if (input == 5 && max == 6 && !w.hasExclusive)
						SelectingUpgrades(w, items[inventory[select]], "exclusive", cash);

					//Go back
					if (input == -1)
					{
						ResetSelection(false);
						break;
					}
				}
			}
		}
		#pragma endregion

		#pragma region ExitGame
		if (input == -1 || input == 4)
		{
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), GOLDCOLOR);
			cout << "\"Come back anytime!\"" << endl;
			_getch();
			break;
		}
		#pragma endregion
	}
}

void Initialize()
{
	DisableCursor();

	//Sets selections to default
	for (int i = 0; i < 3; i++)
	{
		ps[i] = 1;
	}

	//Initialize item. Set actual values later (if any).
	for (int i = 0; i < itemArrayLength; i++)
	{
		itemArray[i].quantity = 0;
		itemArray[i].sellOnly = false;
		itemArray[i].isWeapon = false;
		itemArray[i].sellQuantity = 1;
		itemArray[i].cost = 0;
	}

	//Initialize weapon. Set actual values later (if any).
	for (int i = 0; i < weaponArrayLength; i++)
	{
		weaponArray[i].quantity = 0;
		weaponArray[i].sellOnly = false;
		weaponArray[i].isWeapon = true;
		weaponArray[i].sellQuantity = 1;
		weaponArray[i].cost = 0;
		weaponArray[i].baseCost = 0;

		weaponArray[i].descriptionBase = "";
		weaponArray[i].descriptionExclusive = "";
		weaponArray[i].exclusiveDescription = "";
		weaponArray[i].exclusiveStat = 0;
		weaponArray[i].exclusiveCost = 0;
		weaponArray[i].hasExclusive = false;

		weaponArray[i].upgradable = true;
		weaponArray[i].firePowerLevel = 1;
		weaponArray[i].firingSpeedLevel = 1;
		weaponArray[i].reloadSpeedLevel = 1;
		weaponArray[i].capacityLevel = 1;

		for (int s = 0; s < weaponStatLength; s++)
		{
			weaponArray[i].statFirePower[s] = 0;
			weaponArray[i].statFiringSpeed[s] = 0;
			weaponArray[i].statReloadSpeed[s] = 0;
			weaponArray[i].statCapacity[s] = 0;
		}

		for (int n = 0; n < weaponCostLength; n++)
		{
			weaponArray[i - 1].firePowerCosts[n] = 0;
			weaponArray[i - 1].firingSpeedCosts[n] = 0;
			weaponArray[i - 1].reloadSpeedCosts[n] = 0;
			weaponArray[i - 1].capacityCosts[n] = 0;
		}
	}

	//Set up items
	itemArray[0].name = "First Aid Spray";
	itemArray[0].cost = 10000;
	itemArray[0].sellQuantity = 5;
	itemArray[0].description = "Completely restores health.";

	itemArray[1].name = "Spinel";
	itemArray[1].cost = 2000;
	itemArray[1].sellOnly = true;
	itemArray[1].description = "Although small in size, it appears to have some value.";

	itemArray[2].name = "Crown";
	itemArray[2].cost = 48000;
	itemArray[2].sellOnly = true;
	itemArray[2].description = "A crown with two divots like something might fit inside.";

	//Set up weapons
	#pragma region HandGun
	weaponArray[0].name = "Hand Gun";
	weaponArray[0].baseCost = 8000;
	weaponArray[0].descriptionBase = "A standard 9mm handgun.";
	weaponArray[0].descriptionExclusive = "No longer your average 9mm handgun, it's chance \nof critical headshots is increased by 5x.";
	weaponArray[0].exclusiveDescription = "Increases chance of critical headshots by 5 times";
	weaponArray[0].exclusiveCost = 57000;

	weaponArray[0].firePower = 1.0f;
	weaponArray[0].firePowerMaxLevel = 6;
	weaponArray[0].firePowerCosts[0] = 7000;
	weaponArray[0].firePowerCosts[1] = 10000;
	weaponArray[0].firePowerCosts[2] = 15000;
	weaponArray[0].firePowerCosts[3] = 18000;
	weaponArray[0].firePowerCosts[4] = 20000;
		for (int i = 0; i < weaponStatLength; i++)
	weaponArray[0].statFirePower[i] = (i * 0.2f) + 1.0f;

	weaponArray[0].firingSpeed = 0.47f;
	weaponArray[0].firingSpeedMaxLevel = 3;
	weaponArray[0].firingSpeedCosts[0] = 5000;
	weaponArray[0].firingSpeedCosts[1] = 12000;
	weaponArray[0].statFiringSpeed[0] = 0.47f;
	weaponArray[0].statFiringSpeed[1] = 0.40f;
	weaponArray[0].statFiringSpeed[2] = 0.33f;

	weaponArray[0].reloadSpeed = 1.73f;
	weaponArray[0].reloadSpeedMaxLevel = 3;
	weaponArray[0].reloadSpeedCosts[0] = 4000;
	weaponArray[0].reloadSpeedCosts[1] = 10000;
	weaponArray[0].statReloadSpeed[0] = 1.73f;
	weaponArray[0].statReloadSpeed[1] = 1.47f;
	weaponArray[0].statReloadSpeed[2] = 0.87f;
	
	weaponArray[0].capacity = 10;
	weaponArray[0].capacityMaxLevel = 6;
	for (int i = 0; i < weaponCostLength; i++)
		weaponArray[0].capacityCosts[i] = (i * 2000) + 4000;
	for (int i = 0; i < weaponStatLength; i++)
		weaponArray[0].statCapacity[i] = (i * 3) + 10.0f;
	#pragma endregion

	#pragma region Shotgun
	weaponArray[1].name = "Shotgun";
	weaponArray[1].baseCost = 20000;
	weaponArray[1].descriptionBase = "A 12-gauge pump-action shotgun.\nDont leave home without it.";
	weaponArray[1].descriptionExclusive = "Now possesses the same destructive power from\nall distances.  Sounds like a winner to me!";
	weaponArray[1].exclusiveDescription = "Significantly increases the destructive force of the\nweapon for long distance targets!";
	weaponArray[1].exclusiveCost = 90000;

	weaponArray[1].firePower = 4.0f;
	weaponArray[1].firePowerMaxLevel = 6;
	for (int i = 0; i <= 3; i++)
		weaponArray[1].firePowerCosts[i] = (i * 5000) + 15000;
	weaponArray[1].firePowerCosts[4] = 45000;
	weaponArray[1].statFirePower[0] = 4.0f;
	weaponArray[1].statFirePower[1] = 4.5f;
	weaponArray[1].statFirePower[2] = 5.0f;
	weaponArray[1].statFirePower[3] = 6.0f;
	weaponArray[1].statFirePower[4] = 7.0f;
	weaponArray[1].statFirePower[5] = 8.0f;

	weaponArray[1].firingSpeed = 1.53f;
	weaponArray[1].firingSpeedMaxLevel = 1;
	weaponArray[1].statFiringSpeed[0] = 1.53f;

	weaponArray[1].reloadSpeed = 3.03f;
	weaponArray[1].reloadSpeedMaxLevel = 3;
	weaponArray[1].reloadSpeedCosts[0] = 7000;
	weaponArray[1].reloadSpeedCosts[1] = 15000;
	weaponArray[1].statReloadSpeed[0] = 3.03f;
	weaponArray[1].statReloadSpeed[1] = 2.43f;
	weaponArray[1].statReloadSpeed[2] = 1.50f;

	weaponArray[1].capacity = 6;
	weaponArray[1].capacityMaxLevel = 6;
	weaponArray[1].capacityCosts[0] = 8000;
	weaponArray[1].capacityCosts[1] = 10000;
	weaponArray[1].capacityCosts[2] = 12000;
	weaponArray[1].capacityCosts[3] = 15000;
	weaponArray[1].capacityCosts[4] = 20000;
	for (int i = 0; i <= 3; i++)
		weaponArray[1].statCapacity[i] = (i * 2) + 6.0f;
	weaponArray[1].statCapacity[4] = 15;
	weaponArray[1].statCapacity[5] = 18;
	#pragma endregion

	#pragma region Rifle
	weaponArray[2].name = "Rifle";
	weaponArray[2].baseCost = 12000;
	weaponArray[2].descriptionBase = "A .223 caliber bolt action rifle.";
	weaponArray[2].descriptionExclusive = "A .223 caliber bolt action rifle.";
	weaponArray[2].exclusiveDescription = "Increases the firepower beyond the weapon's threshold.";
	weaponArray[2].exclusiveCost = 80000;
	weaponArray[2].exclusiveStat = 18.0f;

	weaponArray[2].firePower = 4.0f;
	weaponArray[2].firePowerMaxLevel = 6;
	weaponArray[2].firePowerCosts[0] = 10000;
	weaponArray[2].firePowerCosts[1] = 12000;
	weaponArray[2].firePowerCosts[2] = 20000;
	weaponArray[2].firePowerCosts[3] = 25000;
	weaponArray[2].firePowerCosts[4] = 35000;
	weaponArray[2].statFirePower[0] = 4.0f;
	weaponArray[2].statFirePower[1] = 5.0f;
	weaponArray[2].statFirePower[2] = 6.0f;
	weaponArray[2].statFirePower[3] = 8.0f;
	weaponArray[2].statFirePower[4] = 10.0f;
	weaponArray[2].statFirePower[5] = 12.0f;

	weaponArray[2].firingSpeed = 0.67f;
	weaponArray[2].firingSpeedMaxLevel = 1;
	weaponArray[2].statFiringSpeed[0] = 0.67f;

	weaponArray[2].reloadSpeed = 4.00f;
	weaponArray[2].reloadSpeedMaxLevel = 3;
	weaponArray[2].reloadSpeedCosts[0] = 8000;
	weaponArray[2].reloadSpeedCosts[1] = 18000;
	weaponArray[2].statReloadSpeed[0] = 4.00f;
	weaponArray[2].statReloadSpeed[1] = 3.23f;
	weaponArray[2].statReloadSpeed[2] = 2.33f;

	weaponArray[2].capacity = 5;
	weaponArray[2].capacityMaxLevel = 6;
	weaponArray[2].capacityCosts[0] = 6000;
	weaponArray[2].capacityCosts[1] = 8000;
	weaponArray[2].capacityCosts[2] = 12000;
	weaponArray[2].capacityCosts[3] = 18000;
	weaponArray[2].capacityCosts[4] = 25000;
	weaponArray[2].statCapacity[0] = 5;
	weaponArray[2].statCapacity[1] = 7;
	weaponArray[2].statCapacity[2] = 9;
	weaponArray[2].statCapacity[3] = 12;
	weaponArray[2].statCapacity[4] = 15;
	weaponArray[2].statCapacity[5] = 18;
	#pragma endregion

	#pragma region TMP
	weaponArray[3].name = "TMP";
	weaponArray[3].baseCost = 15000;
	weaponArray[3].descriptionBase = "A fully-automatic machine pistol.\nFires custom 9mms.";
	weaponArray[3].descriptionExclusive = "A fully-automatic machine pistol.\nFires custom 9mms.";
	weaponArray[3].exclusiveDescription = "Increases the firepower beyond the weapon's threshold.";
	weaponArray[3].exclusiveCost = 100000;
	weaponArray[3].exclusiveStat = 1.8f;

	weaponArray[3].firePower = 0.4f;
	weaponArray[3].firePowerMaxLevel = 6;
	weaponArray[3].firePowerCosts[0] = 7000;
	weaponArray[3].firePowerCosts[1] = 14000;
	weaponArray[3].firePowerCosts[2] = 18000;
	weaponArray[3].firePowerCosts[3] = 24000;
	weaponArray[3].firePowerCosts[4] = 35000;
	weaponArray[3].statFirePower[0] = 0.4f;
	weaponArray[3].statFirePower[1] = 0.5f;
	weaponArray[3].statFirePower[2] = 0.6f;
	weaponArray[3].statFirePower[3] = 0.8f;
	weaponArray[3].statFirePower[4] = 1.0f;
	weaponArray[3].statFirePower[5] = 1.2f;

	weaponArray[3].firingSpeed = 0.10f;
	weaponArray[3].firingSpeedMaxLevel = 1;
	weaponArray[3].statFiringSpeed[0] = 0.10f;

	weaponArray[3].reloadSpeed = 2.37f;
	weaponArray[3].reloadSpeedMaxLevel = 3;
	weaponArray[3].reloadSpeedCosts[0] = 5000;
	weaponArray[3].reloadSpeedCosts[1] = 15000;
	weaponArray[3].statReloadSpeed[0] = 2.37f;
	weaponArray[3].statReloadSpeed[1] = 1.93f;
	weaponArray[3].statReloadSpeed[2] = 1.17f;

	weaponArray[3].capacity = 30;
	weaponArray[3].capacityMaxLevel = 6;
	weaponArray[3].capacityCosts[0] = 7000;
	weaponArray[3].capacityCosts[1] = 15000;
	weaponArray[3].capacityCosts[2] = 20000;
	weaponArray[3].capacityCosts[3] = 25000;
	weaponArray[3].capacityCosts[4] = 35000;
	weaponArray[3].statCapacity[0] = 30;
	for (int i = 1; i < weaponStatLength; i++)
		weaponArray[3].statCapacity[i] = i * 50.0f;
	#pragma endregion

	#pragma region Rocket Launcher
	weaponArray[4].name = "Rocket Launcher";
	weaponArray[4].baseCost = 30000;
	weaponArray[4].upgradable = false;
	weaponArray[4].descriptionBase = "Do major damage to any target. (Single fire)";
	#pragma endregion

	#pragma region Broken Butterfly 
	weaponArray[5].name = "Broken Butterfly";
	weaponArray[5].baseCost = 38000;
	weaponArray[5].descriptionBase = "A very powerful .45 magnum revolver.\nThis will make anyones day.";
	weaponArray[5].descriptionExclusive = "A very powerful .45 magnum revolver.\nThis will make anyones day.";
	weaponArray[5].exclusiveDescription = "Increases the firepower beyond the weapon's threshold.";
	weaponArray[5].exclusiveCost = 150000;
	weaponArray[5].exclusiveStat = 50.0f;

	weaponArray[5].firePower = 13.0f;
	weaponArray[5].firePowerMaxLevel = 6;
	weaponArray[5].firePowerCosts[0] = 25000;
	weaponArray[5].firePowerCosts[1] = 30000;
	weaponArray[5].firePowerCosts[2] = 35000;
	weaponArray[5].firePowerCosts[3] = 50000;
	weaponArray[5].firePowerCosts[4] = 70000;
	weaponArray[5].statFirePower[0] = 13.0f;
	weaponArray[5].statFirePower[1] = 15.0f;
	weaponArray[5].statFirePower[2] = 17.0f;
	weaponArray[5].statFirePower[3] = 20.0f;
	weaponArray[5].statFirePower[4] = 24.0f;
	weaponArray[5].statFirePower[5] = 28.0f;

	weaponArray[5].firingSpeed = 0.70f;
	weaponArray[5].firingSpeedMaxLevel = 1;
	weaponArray[5].statFiringSpeed[0] = 0.70f;

	weaponArray[5].reloadSpeed = 3.67f;
	weaponArray[5].reloadSpeedMaxLevel = 3;
	weaponArray[5].reloadSpeedCosts[0] = 15000;
	weaponArray[5].reloadSpeedCosts[1] = 20000;
	weaponArray[5].statReloadSpeed[0] = 3.67f;
	weaponArray[5].statReloadSpeed[1] = 3.00f;
	weaponArray[5].statReloadSpeed[2] = 2.33f;

	weaponArray[5].capacity = 6;
	weaponArray[5].capacityMaxLevel = 4;
	for (int i = 0; i <= 2; i++)
		weaponArray[5].capacityCosts[i] = (i * 5000) + 15000;
	for (int i = 0; i <= 3; i++)
		weaponArray[5].statCapacity[i] = (i * 2) + 6.0f;
	#pragma endregion

	#pragma region Mine Thrower
	weaponArray[6].name = "Mine Thrower";
	weaponArray[6].baseCost = 28000;
	weaponArray[6].descriptionBase = "This weapon fires custom mines that attach\nto objects and detonate after a period of time.";
	weaponArray[6].descriptionExclusive = "This weapon now fires \"Homing-mines\" that attach\nto objects and detonate after a period of time.";
	weaponArray[6].exclusiveDescription = "Adds \"homing\" to the Mine-Darts and significantly\nincreases their blast radius.";
	weaponArray[6].exclusiveCost = 30000;

	weaponArray[6].firePower = 2.0f;
	weaponArray[6].firePowerMaxLevel = 3;
	weaponArray[6].firePowerCosts[0] = 25000;
	weaponArray[6].firePowerCosts[1] = 45000;
	weaponArray[6].statFirePower[0] = 2.0f;
	weaponArray[6].statFirePower[1] = 4.0f;
	weaponArray[6].statFirePower[2] = 6.0f;

	weaponArray[6].firingSpeed = 1.33f;
	weaponArray[6].firingSpeedMaxLevel = 1;
	weaponArray[6].statFiringSpeed[0] = 1.33f;
	
	weaponArray[6].reloadSpeed = 3.43f;
	weaponArray[6].reloadSpeedMaxLevel = 2;
	weaponArray[6].reloadSpeedCosts[0] = 18000;
	weaponArray[6].statReloadSpeed[0] = 3.43f;
	weaponArray[6].statReloadSpeed[1] = 2.57f;

	weaponArray[6].capacity = 5;
	weaponArray[6].capacityMaxLevel = 3;
	weaponArray[6].capacityCosts[0] = 25000;
	weaponArray[6].capacityCosts[1] = 40000;
	weaponArray[6].statCapacity[0] = 5;
	weaponArray[6].statCapacity[1] = 7;
	weaponArray[6].statCapacity[2] = 10;
	#pragma endregion

	//Now that weapons are done, set some base stats
	for (int i = 0; i < weaponArrayLength; i++)
	{
		weaponArray[i].cost = weaponArray[i].baseCost;
		weaponArray[i].description = weaponArray[i].descriptionBase;
	}

	//Initialize items. Put all items and weapons into this array.
	for (int i = 0; i < itemArrayLength + weaponArrayLength; i++)
	{
		if (i < weaponArrayLength)
			items[i] = weaponArray[i];
		else
			items[i] = itemArray[i - weaponArrayLength];
	}

	//Initialize selling items.
	for (int i = 0; i < merchantSellingLength; i++)
	{
		merchantSelling[i] = -1;
	}

	int slot = 0;
	//Then sets them to any sellable items
	for (int i = 0; i < merchantSellingLength; i++)
	{
		if (!items[i].sellOnly)
		{
			merchantSelling[slot] = i;
			slot++;
		}
	}
}

void ShowBuyItems(int _cash)
{
	//Shows whats for sale
	system("cls");

	SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), WHITECOLOR);
	cout << left << std::setw(25) << "BUY" << _cash << " PTAS" << endl;
	SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), GOLDCOLOR);
	cout << endl
		 << "\"Whatreya buyin?\"" << endl
		 << endl;

	//Shows all the items that arent sell only
	int i;
	for (i = 0; i < merchantSellingLength && merchantSelling[i] >= 0; i++)
	{
		weapon& w = weaponArray[merchantSelling[selection - 1]];
		item& s = items[merchantSelling[i]];

		cout << ((selection == i + 1) ? SetSelectedColor() : (s.sellQuantity == 0) ? SetGreyedColor() : SetUnselectedColor()) << "\b";
		((i < 9) ? cout << i + 1 : cout << char(88 + i)) << ". " << left << std::setw(18) << s.name << right << std::setw(7) << s.cost << " PTAS";
		SetUnselectedColor();

		if (s.sellQuantity == 0)
		{
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), REDCOLOR);
			cout << left << std::setw(16) << " OUT OF STOCK";
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), UNSELECTEDCOLOR);
		}
		else if (s.sellQuantity > 1)
			cout << " X " << left << std::setw(12) << s.sellQuantity;
		else if (w.upgradable && i >= 0 && i <= 3)
			cout << right << std::setw(16) << "";

		//Cant use function because it shows base stats
		#pragma region Show weapon stats
		if (i == 0 && items[merchantSelling[selection - 1]].isWeapon && w.upgradable)
		{
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), WHITECOLOR);
			cout << left << std::setw(15) << "Firepower" << "Firing Speed";
		}
		else if (i == 1 && items[merchantSelling[selection - 1]].isWeapon && w.upgradable)
		{
			int spacing = 7;

			//Firepower stat
			cout << "Lv";
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),TEALCOLOR);
			cout << BOX;
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), REDCOLOR);
			for (int l = 1; l < w.firePowerMaxLevel; l++)
			{
				cout << BOX;
				spacing--;
			}

			SetUnselectedColor();
			cout << right << std::setw(spacing) << "" << left << std::setw(5) << setprecision(1) << fixed << w.statFirePower[0];
				
			spacing = 7;

			//Firing speed stat
			cout << "Lv";
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),TEALCOLOR);
			cout << BOX;
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), REDCOLOR);
			for (int l = 1; l < w.firingSpeedMaxLevel; l++)
			{
				cout << BOX;
				spacing--;
			}

			SetUnselectedColor();
			cout << right << std::setw(spacing) << "" << setprecision(2) << fixed << w.statFiringSpeed[0];
		}
		else if (i == 2 && items[merchantSelling[selection - 1]].isWeapon && w.upgradable)
		{
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), WHITECOLOR);
			cout << left << std::setw(15) << "Reload Speed" << "Capacity";
		}
		else if (i == 3 && items[merchantSelling[selection - 1]].isWeapon && w.upgradable)
		{
			int spacing = 7;

			//Reload speed stat
			cout << "Lv";
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),TEALCOLOR);
			cout << BOX;
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), REDCOLOR);
			for (int l = 1; l < w.reloadSpeedMaxLevel; l++)
			{
				cout << BOX;
				spacing--;
			}

			SetUnselectedColor();
			cout << right << std::setw(spacing) << "" << left << std::setw(5) << setprecision(2) << fixed << w.statReloadSpeed[0];
				
			spacing = 7;

			//Capacity stat
			cout << "Lv";
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),TEALCOLOR);
			cout << BOX;
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), REDCOLOR);
			for (int l = 1; l < w.capacityMaxLevel; l++)
			{
				cout << BOX;
				spacing--;
			}

			SetUnselectedColor();
			cout << right << std::setw(spacing) << "" << setprecision(0) << fixed << w.statCapacity[0];
		}
		#pragma endregion

		cout << endl;
	}
	cout << endl
		 << " " << items[merchantSelling[selection - 1]].name << endl
		 << items[merchantSelling[selection - 1]].description << endl;
}

void ShowSellItems(int _cash)
{
	//Shows what you can sell
	system("cls");

	SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), WHITECOLOR);
	cout << left << std::setw(25) << "SELL" << _cash << " PTAS" << endl;
	SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), GOLDCOLOR);
	cout << endl
		 << "\"Whatreya sellin?\"" << endl
		 << endl;
			
	SortInventory(false);
	//Check if your selection is on a valid item
	if (inventory[selection - 1] == -1)
	{
		selection -= 1;
	}
	if (inventory[0] == -1)
		goto end;

	int i;
	//Shows all the items in your inventory
	for (i = 0; i < inventoryLength && inventory[i] >= 0 || i <= 3; i++)
	{
		if (inventory[i] >= 0)
		{
			cout << ((selection == i + 1) ? SetSelectedColor() : SetUnselectedColor()) << "\b";
			((i < 9) ? cout << i + 1 : cout << char(88 + i)) << ". " << left << std::setw(18) << items[inventory[i]].name << "X  " << left << std::setw(3) << items[inventory[i]].quantity << right << std::setw(9) << GetItemCost(items[inventory[i]]) << " PTAS";
			SetUnselectedColor();
		}
		else
			cout << left << std::setw(41) << "";

		if (items[inventory[selection - 1]].isWeapon && i >= 0 && i <= 3)
				cout << right << std::setw(8) << "";

		if (items[inventory[selection - 1]].isWeapon)
			ShowWeaponStats(weaponArray[inventory[selection - 1]], items[inventory[selection - 1]], i, false);
		cout << endl;
	}
	cout << endl
		 << " " << items[inventory[selection - 1]].name << endl
		 << items[inventory[selection - 1]].description << endl;
	end :;
}

void ShowUpgradeItems(int _cash)
{
	//Shows what you can upgrade
	system("cls");
	SortInventory(true);

	SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), WHITECOLOR);
	cout << left << std::setw(25) << "TUNE UP" << _cash << " PTAS" << endl;
	SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), GOLDCOLOR);
	cout << endl
		 << "\"Whatreya buyin?\"" << endl
		 << endl;

	int n = 0; //For selected/unselected
	int m = 0; //How many items you actually can upgrade

	for (int i = 0; i < weaponArrayLength; i++)
		if (weaponArray[i].upgradable)
			m++;

	//Shows all the weapons in your inventory
	for (int i = 0; i < weaponArrayLength; i++)
	{
		if (weaponArray[i].upgradable)
		{
			cout << ((selection == n + 1) ? SetSelectedColor() : (weaponArray[inventory[n]].hasExclusive || items[inventory[n]].quantity == 0) ? SetGreyedColor() : SetUnselectedColor()) << "\b";
			((i < 9) ? cout << n + 1 : cout << char(88 + i)) << ". " << left << std::setw(17) << weaponArray[inventory[n]].name;
			SetUnselectedColor();
			cout << left << std::setw(29) << "";
			n++;

			if (selection != m + 1)
			{
				ShowWeaponStats(weaponArray[inventory[selection - 1]], items[inventory[selection - 1]], i, false);
				if (weaponArray[n].upgradable || i < 4)
					cout << endl;
			}

		}
	}
	cout << endl
		 << " " << items[inventory[selection - 1]].name << endl
		 << weaponArray[inventory[selection - 1]].descriptionBase << endl;
}

void ShowUpgrades(int _cash, int _select, int _max)
{
	//Shows what you can upgrade
	system("cls");
	weapon& w = weaponArray[inventory[_select]];

	SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), WHITECOLOR);
	cout << left << std::setw(25) << "TUNE UP" << _cash << " PTAS" << endl
		 << endl;

	for (int i = 0; i <= _max - 2; i++)
	{
		cout << ((selection == i + 1) ? SetSelectedColor() : SetUnselectedColor()) << "\b" << i + 1 << ". ";
		if (i == 0)
		{
			//Firepower
			cout << left << std::setw(15) << "Firepower";
			if (w.firePowerLevel != w.firePowerMaxLevel)
			{
				cout << "Lv " << left << std::setw(4) << w.firePowerLevel + 1
					 << left << std::setw(5) << setprecision(1) << fixed << w.statFirePower[w.firePowerLevel]
					 << right << std::setw(5) << w.firePowerCosts[w.firePowerLevel - 1] << " PTAS";
			}

			SetUnselectedColor();
		}
		else if (i == 1)
		{
			//Firing Speed
			cout << left << std::setw(15) << "Firing Speed";
				if (w.firingSpeedLevel != w.firingSpeedMaxLevel)
				{
					cout << "Lv " << left << std::setw(4) << w.firingSpeedLevel + 1
						 << left << std::setw(5) << setprecision(2) << fixed << w.statFiringSpeed[w.firingSpeedLevel]
						 << right << std::setw(5) << w.firingSpeedCosts[w.firingSpeedLevel - 1] << " PTAS";
				}
			SetUnselectedColor();
		}
		else if (i == 2)
		{
			//Reload Speed
			cout << left << std::setw(15) << "Reload Speed";
			if (w.reloadSpeedLevel != w.reloadSpeedMaxLevel)
			{
				cout << "Lv " << left << std::setw(4) << w.reloadSpeedLevel + 1
					 << left << std::setw(5) << setprecision(2) << fixed << w.statReloadSpeed[w.reloadSpeedLevel]
					 << right << std::setw(5) <<w.reloadSpeedCosts[w.reloadSpeedLevel - 1] << " PTAS";
			}
			SetUnselectedColor();
		}
		else if (i == 3)
		{
			//Capacity
			cout << left << std::setw(15) << "Capacity";
			if (w.capacityLevel != w.capacityMaxLevel)
			{
				cout << "Lv " << left << std::setw(4) << w.capacityLevel + 1
					 << left << std::setw(5) << setprecision(0) << fixed << w.statCapacity[w.capacityLevel]
					 << right << std::setw(5) << w.capacityCosts[w.capacityLevel - 1] << " PTAS";
			}
			SetUnselectedColor();
		}
		else if (i == 4 && _max == 6)
			cout << left << std::setw(30) << "Exclusive" << w.exclusiveCost << " PTAS";	

		SetUnselectedColor();
		if (i == 0 && w.firePowerLevel == w.firePowerMaxLevel || i == 1 && w.firingSpeedLevel == w.firingSpeedMaxLevel ||
				i == 2 && w.reloadSpeedLevel == w.reloadSpeedMaxLevel || i == 3 && w.capacityLevel == w.capacityMaxLevel)
			cout << left << std::setw(22) << "";

		cout << left << std::setw(9) << "";
		ShowWeaponStats(weaponArray[inventory[_select]], items[inventory[_select]], i, true);
		if (i == 3 && _max != 6)
			cout << endl;
		cout << endl;
	}
	//Upgrade descriptions
	cout << endl;
	if (selection == 1)
		 cout << FPDESCRIPTION;
	else if (selection == 2)
		cout << FSDESCRIPTION;
	else if (selection == 3)
		cout << RSDESCRIPTION;
	else if (selection == 4)
		cout << CDESCRIPTION;
	else if (selection == 5)
		cout << " Exclusive" << endl << w.exclusiveDescription;

	cout << endl;
}

void GetInput(int _maxSelections)
{
	char check;
	//Get key states
	while (true)
	{
		if (_kbhit())
		{
			char c = _getch();
			check = c;

			//Press enter (accept)
			if (GetKeyState(VK_RETURN) < 0)
			{
				input = selection;
				break;
			}
			//Alternate selection, used for yes no, or quantities
			else if (_maxSelections == 0)
			{
				if (GetKeyState(VK_LEFT) < 0)
				{
					selection -= 10;
					break;
				}
				else if (GetKeyState(VK_RIGHT) < 0)
				{
					selection += 10;
					break;
				}
				else if (GetKeyState(VK_UP) < 0)
				{
					selection++;
					break;
				}
				else if (GetKeyState(VK_DOWN) < 0)
				{
					selection--;
					break;
				}
				//Press back
				else if (c == 27 || c == 8 || c == 32) //27 = escape, 8 = backspace, 32 = spacebar
				{
					input = -1;
					break;
				}
			}
			//Press a valid number
			else if (c - '0' < _maxSelections && c - '0' > 0)
			{
				selection = c - '0';
				break;
			}
			//Press a valid letter
			else if (c > 96 && c < 122 && 9 + c - 96 < _maxSelections)
			{
				selection = 9 + c - 96;
				break;
			}
			//Press up
			else if (GetKeyState(VK_UP) < 0)
			{
				selection = ((selection <= 1) ? _maxSelections - 1 : (selection - 1));
				break;
			}
			//Press down
			else if (GetKeyState(VK_DOWN) < 0)
			{
				selection = ((selection >= _maxSelections - 1) ? 1 : (selection + 1));
				break;
			}
			//Press back
			else if (c == 27 || c == 8 || c == 32) //27 = escape, 8 = backspace, 32 = spacebar
			{
				input = -1;
				break;
			}
		}
	}
	if (check - '0' < _maxSelections && check - '0' > 0)
		Sleep(40); //When you type numbers, goes faster
	else
		Sleep(150); //So the cursor doesnt go so fast
}

void ShowYesNo()
{
	cout << endl;

	//If you are selling and have more than 1 item to sell, asks for amount
	if (level == 2 && items[inventory[input - 1 - 0]].quantity > 1)
	{
		int select = input - 1;
		input = 0;
		selection = 1;

		cout << "How many?" << endl;
		while (true)
		{
			//Makes sure selection doesnt go out of range
			if (selection == items[inventory[select]].quantity + 1 || selection == items[inventory[select]].quantity + 10)
				selection = 1;
			else if (selection > items[inventory[select]].quantity)
				selection = items[inventory[select]].quantity;

			if (selection == 0 || selection == -9)
				selection = items[inventory[select]].quantity;
			else if (selection <= 0)
				selection = 1;

			cout << "\b \b\b" << selection;

			GetInput(0);

			//Go back
			if (input == -1)
				break;

			if (input > 0 && input <= items[inventory[select]].quantity)
			{
				sellAmount = input;
				cout << "X" << "   " << GetItemCost(items[inventory[select]]) << " PTAS" << endl << endl;
				input = select;
				break;
			}
		}
	}

	//If you pressed back, go back
	if (input == -1)
		return;

	bool special = BuySellMessage();
	input = 0;

	//Start on cancel when selling
	if (level == 2)
		selection = 2;
	else
		selection = 1;

	//Checks for yes or no
	while (input ==  0)
	{
		if (special)
		{
			cout << "\r                      \r    ";
			cout << ((selection == 1) ? SetSelectedColor() : SetUnselectedColor()) << "\b";
			cout << ((level == 1) ?  "Buy" : "Sell");
			cout << SetUnselectedColor() << "\b	     ";
			cout << ((selection == 2) ? SetSelectedColor() : SetUnselectedColor()) << "\b" << "Quit";
			SetUnselectedColor();
		}
		else
		{
			cout << "\r                      \r    ";
			cout << ((selection == 1) ? SetSelectedColor() : SetUnselectedColor()) << "\b" << "Yes";
			cout << SetUnselectedColor() << "\b	     ";
			cout << ((selection == 2) ? SetSelectedColor() : SetUnselectedColor()) << "\b" << "No";
			SetUnselectedColor();
		}

		GetInput(0);

		//Make sure selection doesnt go out of range
		if (selection == 2 + 10)
			selection = 1;
		else if (selection == 1 - 10)
			selection = 2;
		else if (selection <= 0)
			selection = 1;
		else if (selection >= 3)
			selection = 2;
	}

	//If you select no, sets input to go back
	if (input == 2)
		input = -1;
}

void SelectingUpgrades(weapon& _w, item& _i, string _stat, int &_cash)
{
	ps[selectionLevel] = selection;
	selectionLevel += 1;
	while (true)
	{
		//Dont have enough cash
		if (_stat == "firePower" && _cash < _w.firePowerCosts[_w.firePowerLevel - 1]
			|| _stat == "firingSpeed" && _cash < _w.firingSpeedCosts[_w.firingSpeedLevel - 1]
			|| _stat == "reloadSpeed" && _cash < _w.reloadSpeedCosts[_w.reloadSpeedLevel - 1]
			|| _stat == "capacity" && _cash < _w.capacityCosts[_w.capacityLevel - 1]
			|| _stat == "exclusive" && _cash < _w.exclusiveCost)
		{
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), GOLDCOLOR);
			cout << endl << "\"Not enough cash, stranger!\"";
			_getch();
			system("cls");
			input =  0;
			break;
		}

		cout << endl << "Custom tune?" << endl;
		ShowYesNo();

		if (input == 1)
		{
			if (_stat == "firePower")
			{
				_i.cost += _w.firePowerCosts[_w.firePowerLevel - 1];
				_cash -= _w.firePowerCosts[_w.firePowerLevel - 1];

				_w.firePower = _w.statFirePower[_w.firePowerLevel];
				_w.firePowerLevel += 1;
			}
			else if (_stat == "firingSpeed")
			{
				_i.cost += _w.firingSpeedCosts[_w.firingSpeedLevel - 1];
				_cash -= _w.firingSpeedCosts[_w.firingSpeedLevel - 1];

				_w.firingSpeed = _w.statFiringSpeed[_w.firingSpeedLevel];
				_w.firingSpeedLevel += 1;
			}
			else if (_stat == "reloadSpeed")
			{
				_i.cost += _w.reloadSpeedCosts[_w.reloadSpeedLevel - 1];
				_cash -= _w.reloadSpeedCosts[_w.reloadSpeedLevel - 1];

				_w.reloadSpeed = _w.statReloadSpeed[_w.reloadSpeedLevel];
				_w.reloadSpeedLevel += 1;
			}
			else if (_stat == "capacity")
			{
				_i.cost += _w.capacityCosts[_w.capacityLevel - 1];
				_cash -= _w.capacityCosts[_w.capacityLevel - 1];

				_w.capacity = _w.statCapacity[_w.capacityLevel];
				_w.capacityLevel += 1;
			}
			else if (_stat == "exclusive")
			{
				if (_w.name == "Rifle" || _w.name == "TMP" || _w.name == "Broken Butterfly")
					_w.firePower = _w.exclusiveStat;

				_i.cost += _w.exclusiveCost;
				_cash -= _w.exclusiveCost;

				_i.description = _w.descriptionExclusive;
				_w.hasExclusive = true;
			}

			_i.cost = RoundUp(_i.cost);

			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), GOLDCOLOR);
			cout << endl << endl << "\"Ehehe.....thank you!\"";
			_getch();
			ResetSelection(false);
			if (_stat == "exclusive")
				input = -1;
			break;
		}
		else if (input == -1)
		{
			ResetSelection(false);
			break;
		}
	}
}

void ShowWeaponStats(weapon& _w, item& _i, int _n, bool _highlight)
{
	if (!_i.isWeapon || !_w.upgradable)
		return;

	if (_n == 0)
	{
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), WHITECOLOR);

		if (_highlight && selection == 1)
			cout << SetSelectedColor() << "\b";

		cout << left << std::setw(15) << "Firepower";

		if (_highlight && selection == 2)
			cout << SetSelectedColor() << "\b";
		else
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), WHITECOLOR);

		cout << left << std::setw(15) << "Firing Speed";

		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), UNSELECTEDCOLOR);
	}
	else if (_n == 1)
	{
		int spacing = 7;

		//Firepower stat
		cout << "Lv ";
		for (int l = 0; l < _w.firePowerMaxLevel; l++)
		{
			if (l < _w.firePowerLevel)
				SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), TEALCOLOR);
			else
				SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), REDCOLOR);

			if (_w.hasExclusive)
				if (_w.name == "Hand Gun" || _w.name == "Shotgun" || _w.name == "Rifle" ||
				_w.name == "TMP" || _w.name == "Broken Butterfly" || _w.name == "Mine Thrower")
					SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), YELLOWCOLOR);
			cout << BOX;
			spacing--;
		}

		SetUnselectedColor();
		cout << right << std::setw(spacing) << "" << left << std::setw(5) << setprecision(1) << fixed <<_w.firePower;
				
		spacing = 7;

		//Firing speed stat
		cout << "Lv ";
		for (int l = 0; l < _w.firingSpeedMaxLevel; l++)
		{
			if (l < _w.firingSpeedLevel)
				SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),TEALCOLOR);
			else
				SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), REDCOLOR);
			cout << BOX;
			spacing--;
		}

		SetUnselectedColor();
		cout << right << std::setw(spacing) << "" << setprecision(2) << fixed << _w.firingSpeed;
	}
	else if (_n == 2)
	{
		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), WHITECOLOR);

		if (_highlight && selection == 3)
			cout << SetSelectedColor() << "\b";

		cout << left << std::setw(15) << "Reload Speed";

		if (_highlight && selection == 4)
			cout << SetSelectedColor() << "\b";
		else
			SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), WHITECOLOR);

		cout << left << std::setw(15) << "Capacity";

		SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), UNSELECTEDCOLOR);
	}
	else if (_n == 3)
	{
		int spacing = 7;

		//Reload speed stat
		cout << "Lv ";
		for (int l = 0; l < _w.reloadSpeedMaxLevel; l++)
		{
			if (l < _w.reloadSpeedLevel)
				SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),TEALCOLOR);
			else
				SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), REDCOLOR);
			cout << BOX;
			spacing--;
		}

		SetUnselectedColor();
		cout << right << std::setw(spacing) << "" << left << std::setw(5) << setprecision(2) << fixed << _w.reloadSpeed;
				
		spacing = 7;

		//Capacity stat
		cout << "Lv ";
		for (int l = 0; l < _w.capacityMaxLevel; l++)
		{
			if (l < _w.capacityLevel)
				SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),TEALCOLOR);
			else
				SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), REDCOLOR);
			cout << BOX;
			spacing--;
		}

		SetUnselectedColor();
		cout << right << std::setw(spacing) << "" << setprecision(0) << fixed << _w.capacity;
	}
}

bool BuySellMessage()
{
	SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), GOLDCOLOR);
	//If you are buying some things, gives you different messages.
	if (level == 1)
	{
		if (items[merchantSelling[input - 1]].name == "Mine Thrower")
		{
			cout << BUYMINETHROWER << endl;
			return true;
		}
		else if (items[merchantSelling[input - 1]].name == "Broken Butterfly")
		{
			cout << buyBB << endl;
			return true;
		}
	}

	//If you sell a single item that is over 10k, or a weapon over 30k, says something different
	else if (level == 2)
	{
		if (!items[inventory[input - 1]].isWeapon && GetItemCost(items[inventory[input - 1]]) / sellAmount > 10000
		  || items[inventory[input - 1]].isWeapon && GetItemCost(items[inventory[input - 1]]) / sellAmount > 30000)
		{
			cout << "   \"Ah! Ill buy it at a high price!\"" << endl;
			return true;
		}
	}
	else
		cout << "\"Is that all, stranger?\"" << endl << endl;

	//Buy? Sell? Custom Tune?
	SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), UNSELECTEDCOLOR);
	if (level == 1)
		cout << "   Buy?" << endl;
	if (level == 2)
		cout << "   Sell?" << endl;
	if (level == 3)
		cout << "   Custom Tune?" << endl;

	return false;
}

int RoundUp(int numberToRound)  
{
	 int remainder = numberToRound % 100; 

	 if (remainder == 0)
	  {
		return numberToRound; 
	  }

	 return numberToRound + 100 - remainder; 
} 

void SortInventory(bool _upgradables)
{
	int slot = 0;

	//Resets inventory
	for (int i = 0; i < 10; i++)
	{
		inventory[i] = -1;
	}

	//Then sets them to the items I have, in order
	if (_upgradables)
	{
		for (int i = 0; i < 10; i++)
		{
			if (items[i].isWeapon && weaponArray[i].upgradable)
			{
				inventory[slot] = i;
				slot++;
			}
		}
	}
	else
	{
		for (int i = 0; i < 10; i++)
		{
			if (items[i].quantity > 0)
			{
				inventory[slot] = i;
				slot++;
			}
		}
	}
}

int GetItemCost(item _item)
{
	//If the item is sell only, doesnt use the sell multiplier (makes it easy to sell things for a certain cost)
	if (_item.sellOnly)
		return _item.cost * sellAmount;
	else
	{
		int number = RoundUp((int)(_item.cost * SELLMULTIPLIER));
		return number * sellAmount;
	}
}

BOOL SetSelectedColor()
{
	return SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), SELECTEDCOLOR);
}

BOOL SetUnselectedColor()
{
	return SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), UNSELECTEDCOLOR);
}

BOOL SetGreyedColor()
{
	return SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE), GREYCOLOR);
}

void ClearScreen()
{
	//Clears the screen without much flickering.
	HANDLE hOut;
    COORD Position;

    hOut = GetStdHandle(STD_OUTPUT_HANDLE);

    Position.X = 0;
    Position.Y = 0;
    SetConsoleCursorPosition(hOut, Position);
}

void ResetSelection(bool _in)
{
	if (_in)
	{
		ps[selectionLevel] = selection;
		selectionLevel += 1;
		selection = 1;
	}
	else
	{
		ps[selectionLevel] = 1;
		selectionLevel -= 1;
		selection = ps[selectionLevel];
	}
	input =  0;
}

void DisableCursor()
{
	//Disables the blinking curor
	HANDLE hConsole = GetStdHandle(STD_OUTPUT_HANDLE);
	CONSOLE_CURSOR_INFO CursoInfo;
	CursoInfo.dwSize = 1;
	CursoInfo.bVisible = false;
	SetConsoleCursorInfo(hConsole, &CursoInfo);
}