#ifndef _SAVE_LOAD_H_
#define _SAVE_LOAD_H_

#include <fstream>
#include <string>
#include <list>

static unsigned int mSeed; //For getting the same randoms

class SaveLoad
{
	std::ifstream in;
	static const int length = 100;
	char str[length];

	int currentActionCount;
	int loadActionCount; //Will be loaded in, mActionCount will be remade when loading all the actions
	unsigned int mActionCount;

	std::list <std::string> mActions;
	//For saving how long you have played
	time_t mStartTime;
	time_t mEndTime;
	double mElapsedTime;
	std::string mDateTime;

	void LoadLastFive();
public:
	SaveLoad();
	void AddAction(const std::string aInput);
	void SaveGame(std::string& aFileName);
	void LoadGame(const std::string& aFileName);
	void LoadSaveSlot(const std::string& aFileName);
	void ResetVariables();
	void GetNextInput();
	std::string GetTimes(); //Used by end sequence
};

#endif //Close _SAVE_LOAD_H_