#ifndef _MAIN_H_
#define _MAIN_H_

#include <iostream>
#include <string>
#include <list>
#include "Parser.h"
#include "Input.h"
#include "Output.h"
#include "Item.h"
#include "Room.h"
#include "Action.h"
#include "NPC.h"
#include "SaveLoad.h"

//Score Additions
static const int sScoreGiveItem = 2; //How much score to give when on a new state
static const int sScoreNewState = 1; //Give/show item used for first time

static const int sScoreCheckItem = 1; //How much score to give when checking an item for the first time
static const int sScoreTakeItem = 1; //Take item used for first time
static const int sScoreHoldUse = 2; //Use/hold correct item for first time

static const int sScoreNewRoom = 3; //Score to add when getting to a new room for the first time
static const int sScorePuzzleRoom = 10; //Score for completing a puzzle for the first time

enum descriptionMode
{
	eVerbose,
	eBrief,
	eSuperbrief,
	eINVALID
};

class Main
{
	//SINGLETONS RULEZ!! ~Matt Knowles
	static Main* sInstance;
	Main();

	static const int sRoomArrayCount = 20;
	Room* mRooms[sRoomArrayCount];

	int mTurns;
	int mScore;
	int mMaxScore;
	bool mQuitGame;
	bool mFirstRun; //This is for not having the load system reset everything on load

	void InitializeRooms();
	void UpdateRoom();
	void CheckRoomState();
	void ShowStartScreen();
public:
	~Main(); //Needed for reseting the game

	Room* mCurrentRoom;
	Parser mParser;
	Output mOut;
	Input mIn;
	SaveLoad mSaveLoad;
	NPC* mHelp;
	ActionList* mActions;
	list <Item*> mInventory;

	std::string mInput;
	descriptionMode mDesMode;

	static Main* Get();
	void InitMaxScore(); //This counts up all items/rooms/NPCstates and how much score they can give
	void Reset(bool aShowStartScreen);
	void Run();
	void GetInput();
	void ShowEndScene();
	void CreateHelpNPC();
	void ClearScreenWait(); //Waits for a keypress, then clears the screen and puts description back up
	void ClearScreen();		//Clears the screen and puts description back up

	void AddScore(int aAmount);
	void AddTurn() { ++mTurns; }
	int GetTurn() const { return mTurns; }
	int GetScore() const { return mScore; }
	int GetMaxScore() const { return mMaxScore; }
	void QuitGame() { mQuitGame = true; }
};


#endif //Close _MAIN_H_