#ifndef _ACTION_H_
#define _ACTION_H_

#include "Parser.h"
#include <string>

static int sActionCount;

class IAction
{
public:
	virtual ~IAction() {}
	virtual bool DoAction() = 0;
};

class Action : virtual public IAction
{
public:
	Action();
};

//-------------------------------------//
class Go : public Action
{
public:
	bool DoAction();
};

class Take : public Action
{
public:
	bool DoAction();
};

class CheckInventory : public Action
{
public:
	bool DoAction();
};

class Talk : public Action
{
public:
	bool DoAction();
};

class Save : public Action
{
public:
	bool DoAction();
};

class Load : public Action
{
public:
	bool DoAction();
};

class Use : public Action
{
public:
	bool DoAction();
};

class Check : public Action
{
public:
	bool DoAction();
};

class Restart : public Action
{
public:
	bool DoAction();
};

class Verbose : public Action
{
public:
	bool DoAction();
};

class Brief : public Action
{
public:
	bool DoAction();
};

class Quit : public Action
{
public:
	bool DoAction();
};

class ShowScore : public Action
{
public:
	bool DoAction();
};

class ShowTurns : public Action
{
public:
	bool DoAction();
};

class Push : public Action
{
public:
	bool DoAction();
};

class Pull : public Action
{
public:
	bool DoAction();
};

class Suicide : public Action
{
public:
	bool DoAction();
};

class Profanity: public Action
{
public:
	bool DoAction();
};

class ClearScreen: public Action
{
public:
	bool DoAction();
};

class Help: public Action
{
public:
	bool DoAction();
};

//-------------------------------------//
class ActionList
{
public:
	ActionList();
	~ActionList();
	IAction** mActionList;

	void CheckActions();
	void InvalidInput();
};


#endif //Close _ACTION_H_