class DoomHealthPickup_Stimpack extends UTArmorPickupFactory
    ClassGroup(Doom);

auto state Pickup
{
    function bool ValidTouch( Pawn Other )
    {
        // Pick it up if health is lower than 100
        if (UTPawn(Other).Health < 100)
            return true;
        else
            return false;
    }
}

// Gives you health, can't go above 100
function AddShieldStrength(UTPawn P)
{
    P.Health += ShieldAmount;
    
    if (P.Health > 100)
        P.Health = 100;
        WorldInfo.Game.Broadcast(self, "Picked up a Stimpack.");
    // Disables it so it doesn't respawn
    ShutDown();
}

defaultproperties
{
    ShieldAmount=10
    PickupSound=SoundCue'Doom2Package.Sound.SC_ItemPickup'

    Begin Object Class=UTParticleSystemComponent Name=ArmorParticles
        Translation=(X=0.0,Y=0.0,Z=-28.0)
        Template=ParticleSystem'Doom2Package.Pickups.Stim_PS'
    End Object

    SpinningParticleEffects=ArmorParticles
    Components.Add(ArmorParticles)
}
