class DoomHealthPickup_SmallHealth extends UTArmorPickupFactory
    ClassGroup(Doom);

auto state Pickup
{
    function bool ValidTouch( Pawn Other )
    {
        // Always pick it up
        return true;
    }
}

// Gives you health, can't go above 200
function AddShieldStrength(UTPawn P)
{
    P.Health += ShieldAmount;
    
    if (P.Health > 200)
        P.Health = 200;
    WorldInfo.Game.Broadcast(self, "Picked up a Health Bonus.");
    // Disables it so it doesn't respawn
    ShutDown();
}

defaultproperties
{
    ShieldAmount=1
    PickupSound=SoundCue'Doom2Package.Sound.SC_ItemPickup'

    Begin Object Class=UTParticleSystemComponent Name=ArmorParticles
        Translation=(X=0.0,Y=0.0,Z=-28.0)
        Template=ParticleSystem'Doom2Package.Pickups.Bon1_PS'
    End Object

    SpinningParticleEffects=ArmorParticles
    Components.Add(ArmorParticles)
}
