class DoomHUD extends UTHUD;

var DoomGFxHUD HudMovie;

singular event Destroyed()
{
        // Each HUD element needs to be shut down in the Destroyed() event!
    if (HudMovie != none)
    {
        HudMovie.Close(true);
        HudMovie = none;
    }
    
    super.Destroyed();
}

simulated function PostBeginPlay() 
{
    super.PostBeginPlay();

        // Think of PostBeginPlay as the "Initialized" function for your HUD class, use it to load and initialize your HUD elements!
    HudMovie = new class'DoomGFxHUD';
    HudMovie.SetTimingMode(TM_Real);
    HudMovie.Init(class'Engine'.static.GetEngine().GamePlayers[HudMovie.LocalPlayerOwnerIndex]);
    HudMovie.SetViewScaleMode(SM_NoScale);
    HudMovie.SetAlignment(Align_BottomRight);
}

event PostRender()
{
    super.PostRender();
    
        // You need to Tick each HUD element in PostRender unless it is a purely static element!
    super.PostRender();

    if (HudMovie != none)
        HudMovie.TickHud(0);
}
    
//Gets rid of a lot of UT stuff that I don't want
function DrawGameHud()
{  
    DisplayConsoleMessages();
}
    


// To put messages in the top left
function DisplayConsoleMessages()
{
    local int Idx, XPos, YPos;
    local float XL, YL;

    if (ConsoleMessages.Length == 0 || PlayerOwner.bCinematicMode)
    {
        return;
    }

    for (Idx = 0; Idx < ConsoleMessages.Length; Idx++)
    {
        if ( ConsoleMessages[Idx].Text == "" || ConsoleMessages[Idx].MessageLife < WorldInfo.TimeSeconds )
        {
            ConsoleMessages.Remove(Idx--,1);
        }
    }
    
    ConsoleMessagePosX = bDisplayingPowerups ? 0.1 : 0.0;
    XPos = (ConsoleMessagePosX * HudCanvasScale * Canvas.SizeX) + (((1.0 - HudCanvasScale) / 2.0) * Canvas.SizeX) - Canvas.SizeX * 0.02;
    YPos = (ConsoleMessagePosY * HudCanvasScale * Canvas.SizeY) + (((1.0 - HudCanvasScale) / 2.0) * Canvas.SizeY) - Canvas.SizeY * 0.82;

    Canvas.Font = GetFontSizeIndex(0);

    Canvas.TextSize ("A", XL, YL);

    YPos += YL * ConsoleMessages.Length; // DP_LowerLeft
    YPos += YL; // Room for typing prompt

    for (Idx = 0; Idx < ConsoleMessages.Length; Idx++)
    {
        if (ConsoleMessages[Idx].Text == "")
        {
            continue;
        }
        Canvas.StrLen( ConsoleMessages[Idx].Text, XL, YL );
        Canvas.SetPos( XPos, YPos );
        Canvas.DrawColor = ConsoleMessages[Idx].TextColor;
        Canvas.DrawText( ConsoleMessages[Idx].Text, false );
        YPos -= YL;
    }
}
    

defaultproperties
{
    WeaponSwitchMessage=none
    //HudFonts(0)=Font'Doom2Package.UI.Fonts.doom_font'// for some reason it doesnt show when I build
    bEnableActorOverlays=true
}