class DoomPawn extends UTPawn;

//All this to make sure sound group doesnt load
simulated function SetCharacterClassFromInfo(class<UTFamilyInfo> Info)
{
    local UTPlayerReplicationInfo PRI;
    local int i;
    local int TeamNum;
    local MaterialInterface TeamMaterialHead, TeamMaterialBody, TeamMaterialArms;

    PRI = GetUTPlayerReplicationInfo();

    if (Info != CurrCharClassInfo)
    {
        // Set Family Info
        CurrCharClassInfo = Info;

        // get the team number (0 red, 1 blue, 255 no team)
        TeamNum = GetTeamNum();

        // AnimSets
        Mesh.AnimSets = Info.default.AnimSets;

        //Apply the team skins if necessary
        if (WorldInfo.NetMode != NM_DedicatedServer)
        {
            Info.static.GetTeamMaterials(TeamNum, TeamMaterialHead, TeamMaterialBody);
        }

        // 3P Mesh and materials
        SetCharacterMeshInfo(Info.default.CharacterMesh, TeamMaterialHead, TeamMaterialBody);

        // First person arms mesh/material (if necessary)
        if (WorldInfo.NetMode != NM_DedicatedServer && IsHumanControlled() && IsLocallyControlled())
        {
            TeamMaterialArms = Info.static.GetFirstPersonArmsMaterial(TeamNum);
            SetFirstPersonArmsInfo(Info.static.GetFirstPersonArms(), TeamMaterialArms);
        }

        // PhysicsAsset
        // Force it to re-initialise if the skeletal mesh has changed (might be flappy bones etc).
        Mesh.SetPhysicsAsset(Info.default.PhysAsset, true);

        // Make sure bEnableFullAnimWeightBodies is only TRUE if it needs to be (PhysicsAsset has flappy bits)
        Mesh.bEnableFullAnimWeightBodies = FALSE;
        for(i=0; i<Mesh.PhysicsAsset.BodySetup.length && !Mesh.bEnableFullAnimWeightBodies; i++)
        {
            // See if a bone has bAlwaysFullAnimWeight set and also
            if( Mesh.PhysicsAsset.BodySetup[i].bAlwaysFullAnimWeight &&
                Mesh.MatchRefBone(Mesh.PhysicsAsset.BodySetup[i].BoneName) != INDEX_NONE)
            {
                Mesh.bEnableFullAnimWeightBodies = TRUE;
            }
        }

        //Overlay mesh for effects
        if (OverlayMesh != None)
        {
            OverlayMesh.SetSkeletalMesh(Info.default.CharacterMesh);
        }

        //Set some properties on the PRI
        if (PRI != None)
        {
            PRI.bIsFemale = Info.default.bIsFemale;
            PRI.VoiceClass = Info.static.GetVoiceClass();

            // Assign fallback portrait.
            PRI.CharPortrait = Info.static.GetCharPortrait(TeamNum);

            // a little hacky, relies on presumption that enum vals 0-3 are male, 4-8 are female
            if ( PRI.bIsFemale )
            {
                PRI.TTSSpeaker = ETTSSpeaker(Rand(4));
            }
            else
            {
                PRI. TTSSpeaker = ETTSSpeaker(Rand(5) + 4);
            }
        }

        // Bone names
        LeftFootBone = Info.default.LeftFootBone;
        RightFootBone = Info.default.RightFootBone;
        TakeHitPhysicsFixedBones = Info.default.TakeHitPhysicsFixedBones;

        DefaultMeshScale = Info.Default.DefaultMeshScale;
        Mesh.SetScale(DefaultMeshScale);
        BaseTranslationOffset = CurrCharClassInfo.Default.BaseTranslationOffset;
        CrouchTranslationOffset = BaseTranslationOffset + CylinderComponent.Default.CollisionHeight - CrouchHeight;
    }
}

//Play sound when you land from about the max jump height or higher
simulated event Landed(vector HitNormal, Actor FloorActor)
{
    if( Velocity.Z < -610 )
    {
        PlaySound(FallImpactSound);
    }
}

//Disable jump sound
function PlayJumpingSound()
{
}
    
//Disable double tap
function bool Dodge(eDoubleClickDir DoubleClickMove)
{
}


defaultproperties
{
        //Disable double jump
        MaxMultiJump=0
        MultiJumpRemaining=0
        bCanDoubleJump=false
        
        MaxStepHeight=48.0          //can step up higher
        bCanCrouch=false            //disable crouch
        JumpZ=630.0                 //jump higher
        CustomGravityScaling=2.0    //fall faster
        
        GroundSpeed=900.0           //run faster
        AirSpeed=900.0              //same speed in air
        
        FallImpactSound=SoundCue'Doom2Package.Sound.SC_Oof'
        
        //Disable sounds
        ArmorHitSound=none
        SpawnSound=none
        TeleportSound=none
}