class DoomArmorPickup_SmallArmor extends UTArmorPickupFactory
    ClassGroup(Doom);

auto state Pickup
{
    // Always pick it up
    function bool ValidTouch( Pawn Other )
    {
        return true;
    }
}

// Gives you armor, can't go above 200
function AddShieldStrength(UTPawn P)
{
    P.VestArmor += ShieldAmount;

    if (P.VestArmor > 200)
        P.VestArmor = 200;
    WorldInfo.Game.Broadcast(self, "Picked up an Armor Bonus."); 
    // Disables it so it doesn't respawn
    ShutDown();
}

defaultproperties
{
    ShieldAmount=1
    PickupSound=SoundCue'Doom2Package.Sound.SC_ItemPickup'

    Begin Object Class=UTParticleSystemComponent Name=ArmorParticles
        Translation=(X=0.0,Y=0.0,Z=-30.0)
        Template=ParticleSystem'Doom2Package.Pickups.Bon2_PS'
    End Object

    SpinningParticleEffects=ArmorParticles
    Components.Add(ArmorParticles)
}