class DoomArmorPickup_Armor extends UTArmorPickupFactory
    ClassGroup(Doom);

auto state Pickup
{
    // Pick it up if armor is lower than 100
    function bool ValidTouch( Pawn Other )
    {
        if (UTPawn(Other).VestArmor < 100)
            return true;
        else
            return false;
    }
}

// Gives you armor, can't go above 100
function AddShieldStrength(UTPawn P)
{
    P.VestArmor += ShieldAmount;

    if (P.VestArmor > 100)
    P.VestArmor = 100;
    WorldInfo.Game.Broadcast(self, "Picked up the Armor."); 
    // Disables it so it doesn't respawn
    ShutDown();
}

defaultproperties
{
    ShieldAmount=100
    PickupSound=SoundCue'Doom2Package.Sound.SC_ItemPickup'

    Begin Object Class=UTParticleSystemComponent Name=ArmorParticles
        Translation=(X=0.0,Y=0.0,Z=-30.0)
        Template=ParticleSystem'Doom2Package.Pickups.Arm1_PS'
    End Object

    SpinningParticleEffects=ArmorParticles
    Components.Add(ArmorParticles)
}